/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.straw;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class Straw {
    public static final long OFFSET_BEGIN = -1L;
    private final ExecutorService _executor = Executors.newSingleThreadExecutor();
    private final URL _url;
    private final Map<Integer, Long> _cursors;

    public Straw(URL url, Map<Integer, Long> cursors) {
        this._url = url;
        this._cursors = new HashMap<Integer, Long>(cursors);
    }

    public void start() {
        this._executor.submit(() -> {
            while (true) {
                this.fetchStream();
            }
        });
    }

    protected Map<Integer, Long> getCursors() {
        return Collections.unmodifiableMap(this._cursors);
    }

    protected String loadToken() throws Exception {
        return System.getenv("TOKEN");
    }

    protected void storeCursor(Cursor cursor) throws Exception {
        this.logDebug("storeCursor: " + cursor);
    }

    protected void handleEvents(String json) throws Exception {
        this.logDebug("handleEvents: " + json);
    }

    protected void logDebug(String message) {
        System.out.println("DEBUG: " + message);
    }

    protected void logInfo(String message) {
        System.out.println("INFO: " + message);
    }

    protected void logError(String message) {
        System.out.println("ERROR: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchStream() {
        this.logInfo("fetchStream: " + this.cursorString());
        try (SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(this._url.getHost(), 443);){
            String line;
            this.sendRequest(socket);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            int statusCode = this.readHeaders(in);
            if (statusCode != 200) {
                in.readLine();
                throw new Exception(statusCode + ": " + in.readLine());
            }
            int i = 1;
            while ((line = in.readLine()) != null) {
                if (++i % 3 != 0) continue;
                this.handleBatch(line.trim());
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
            Straw.tryToSleep(2000);
        }
    }

    private void handleBatch(String line) throws Exception {
        if (!line.isEmpty()) {
            Cursor cursor = Cursor.extract(line);
            if (cursor.offset > this._cursors.get(cursor.partition)) {
                this.handleEvents(line);
                this.storeCursor(cursor);
                this._cursors.put(cursor.partition, cursor.offset);
            }
        }
    }

    private void sendRequest(SSLSocket socket) throws Exception {
        socket.startHandshake();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
        out.println("GET " + this._url.getPath() + " HTTP/1.1");
        out.println("Host: " + this._url.getHost());
        out.println("Authorization: Bearer " + this.loadToken());
        out.println("X-Nakadi-Cursors: " + this.cursorString());
        out.println("User-Agent: straw");
        out.println("Accept: */*");
        out.println();
        out.flush();
    }

    private String cursorString() {
        ArrayList<Cursor> result = new ArrayList<Cursor>();
        for (int partition : this._cursors.keySet()) {
            result.add(new Cursor(partition, this._cursors.get(partition)));
        }
        return Arrays.toString(result.toArray());
    }

    private int readHeaders(BufferedReader out) throws IOException {
        String line;
        int statusCode = -1;
        while ((line = out.readLine()) != null) {
            if (statusCode == -1) {
                statusCode = Integer.parseInt(line.split("\\s")[1]);
                continue;
            }
            if (!line.trim().isEmpty()) continue;
            break;
        }
        return statusCode;
    }

    private static void tryToSleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static final class Cursor {
        public final int partition;
        public final long offset;

        static Cursor extract(String line) {
            Scanner scanner = new Scanner(line);
            int partition = Integer.parseInt(scanner.findInLine("\\d+"));
            long offset = Long.parseLong(scanner.findInLine("\\d+"));
            return new Cursor(partition, offset);
        }

        Cursor(int partition, long offset) {
            this.partition = partition;
            this.offset = offset;
        }

        public String toString() {
            return String.format("{\"partition\":\"%d\",\"offset\":\"%s\"}", this.partition, this.offset());
        }

        private String offset() {
            return this.offset == -1L ? "BEGIN" : Long.toString(this.offset);
        }
    }
}

