/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.straw.example;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.zalando.straw.Straw;

public class Example {
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_RESET = "\u001b[0m";

    public static void main(String[] args) throws Exception {
        URL url = new URL("https://nakadi-staging.aruha-test.zalan.do/event-types/trial-gozer-events-1/events");
        Map<Integer, Long> cursors = Collections.singletonMap(0, -1L);
        Straw straw = new Straw(url, (Map)cursors){
            private int _count = 0;

            @Override
            protected void handleEvents(String json) throws Exception {
                ++this._count;
                this.logDebug(this._count + ": " + json);
            }

            @Override
            protected void storeCursor(Straw.Cursor cursor) throws Exception {
                this.logInfo("store cursor: " + cursor);
            }

            @Override
            protected void logDebug(String message) {
                System.out.println(message);
            }

            @Override
            protected void logInfo(String message) {
                System.out.println(Example.ANSI_GREEN + message + Example.ANSI_RESET);
            }

            @Override
            protected void logError(String message) {
                System.out.println(Example.ANSI_RED + message + Example.ANSI_RESET);
            }
        };
        straw.start();
    }
}

