package org.zalando.straw.example;

import org.zalando.straw.Straw;

import java.net.URL;
import java.util.Collections;
import java.util.Map;


public class Example {

    private static final String ANSI_RED = "\u001B[31m";
    private static final String ANSI_GREEN = "\u001B[32m";
    private static final String ANSI_RESET = "\u001B[0m";

    public static void main(String[] args) throws Exception {

        URL url = new URL("https://nakadi-staging.aruha-test.zalan.do/event-types/end2end_monitor.test_invoked_512/events?batch_limit=3");
        Map<Integer, Long> cursors = Collections.singletonMap(0, Straw.OFFSET_BEGIN);

        Straw straw = new Straw(url, cursors) {
            private int _count = 0;

            @Override protected void handleEvents(String json) throws Exception {
                _count++;
                logDebug(_count + ": " + json);
                // TODO: parse json and handle events
            }

            @Override protected void storeCursor(Cursor cursor) throws Exception {
                logInfo("store cursor: " + cursor);
                // TODO: store cursor in etcd
            }

            @Override protected void logDebug(String message) {
                System.out.println(message);
            }

            @Override protected void logInfo(String message) {
                System.out.println(ANSI_GREEN + message + ANSI_RESET);
            }

            @Override protected void logError(String message) {
                System.out.println(ANSI_RED + message + ANSI_RESET);
            }
        };
        straw.start();
    }
}
