package org.zalando.straw.example;

import org.zalando.straw.Straw;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Map;


public class Example {

    // we want colors!
    private static final String ANSI_RED = "\u001B[31m";
    private static final String ANSI_GREEN = "\u001B[32m";
    private static final String ANSI_RESET = "\u001B[0m";

    public static void main(String[] args) throws Exception {

        // example topic
        String topic = "inventory-offering.AVAILABLE_QUANTITIES_CHANGED.V1";
        URL url = new URL("https://nakadi-staging.aruha-test.zalan.do/event-types/" + topic + "/events?batch_limit=1");

        // read from all partitions, starting with the latest offset
        // (note: this is not guaranteed to deliver ALL events, so it should
        // only be used for sampling the stream)
//        Map<Integer, Long> cursors = Collections.emptyMap();

        // read from selected partition, starting with the earliest offset
        Map<Integer, Long> cursors = Collections.singletonMap(0, Straw.OFFSET_BEGIN);

        Straw straw = new Straw(url, cursors) {
            private int _count = 0;

            @Override protected void handleEvents(String json) throws Exception {
                // this is where you would normally parse the json, handle the
                // events and finally store the cursor persistently.
                // here, we just count how many events we have received.
                _count++;
                logDebug(_count + ": " + json);
            }

            @Override protected String loadToken() throws Exception {
                // this method must return a valid authentication token.
                // here, we just fetch a personal token via zign.
                Process p = Runtime.getRuntime().exec("zign token -n nakadi nakadi.event_stream.read");
                try { p.waitFor(); } catch (InterruptedException ignored) {}
                BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try { return b.readLine(); } finally { b.close(); }
            }

            @Override protected void logDebug(String message) {
                System.out.println(message);
            }
            @Override protected void logInfo(String message) {
                System.out.println(ANSI_GREEN + message + ANSI_RESET);
            }
            @Override protected void logError(String message) {
                System.out.println(ANSI_RED + message + ANSI_RESET);
            }
        };
        straw.start();
    }
}
