/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.straw.example;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.zalando.straw.Straw;

public class Example {
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_RESET = "\u001b[0m";

    public static void main(String[] args) throws Exception {
        String topic = "inventory-offering.AVAILABLE_QUANTITIES_CHANGED.V1";
        URL url = new URL("https://nakadi-staging.aruha-test.zalan.do/event-types/" + topic + "/events?batch_limit=1");
        Map<Integer, Long> cursors = Collections.singletonMap(0, -1L);
        Straw straw = new Straw(url, (Map)cursors){
            private int _count = 0;

            @Override
            protected void handleEvents(String json) throws Exception {
                ++this._count;
                this.logDebug(this._count + ": " + json);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String loadToken() throws Exception {
                Process p = Runtime.getRuntime().exec("zign token -n nakadi nakadi.event_stream.read");
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try (BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String string = b.readLine();
                    return string;
                }
            }

            @Override
            protected void logDebug(String message) {
                System.out.println(message);
            }

            @Override
            protected void logInfo(String message) {
                System.out.println(Example.ANSI_GREEN + message + Example.ANSI_RESET);
            }

            @Override
            protected void logError(String message) {
                System.out.println(Example.ANSI_RED + message + Example.ANSI_RESET);
            }
        };
        straw.start();
    }
}

