package org.zalando.straw.example;

import org.zalando.straw.Straw;

import java.net.URL;
import java.util.Collections;
import java.util.Map;


public class Example {

    // we want colors!
    private static final String ANSI_RED = "\u001B[31m";
    private static final String ANSI_GREEN = "\u001B[32m";
    private static final String ANSI_RESET = "\u001B[0m";

    public static void main(String[] args) throws Exception {

        String nakadiHost = "nakadi.example.org";
        String eventType = "my_event_type";
        URL url = new URL("https://" + nakadiHost + "/event-types/" + eventType + "/events");

        // read from all partitions, starting with the latest offset
        // (note: this is not guaranteed to deliver ALL events, so it
        // should only be used for sampling the stream)
//        Map<Integer, Long> cursors = Collections.emptyMap();

        // read from selected partition, starting with the earliest offset
        Map<Integer, Long> cursors = Collections.singletonMap(0, Straw.OFFSET_BEGIN);

        Straw straw = new Straw(url, cursors) {
            private int _count = 0;

            @Override protected void handleEvents(String json) throws Exception {
                // this is where you would normally parse the json, handle the
                // events and finally store the cursor persistently.
                // here, we just count how many events we have received.
                _count++;
                logDebug(_count + ": " + json);
            }

            @Override protected void logDebug(String message) {
                System.out.println(message);
            }

            @Override protected void logInfo(String message) {
                System.out.println(ANSI_GREEN + message + ANSI_RESET);
            }

            @Override protected void logError(Exception e) {
                System.err.println(ANSI_RED);
                e.printStackTrace(System.err);
                System.err.println(ANSI_RESET);
            }
        };
        straw.start();
    }
}
