/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.straw.example;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.zalando.straw.Straw;

public class Example {
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_RESET = "\u001b[0m";

    public static void main(String[] args) throws Exception {
        String nakadiHost = "nakadi.example.org";
        String eventType = "my_event_type";
        URL url = new URL("https://" + nakadiHost + "/event-types/" + eventType + "/events");
        Map<String, String> cursors = Collections.singletonMap("0", "begin");
        Straw straw = new Straw(url, (Map)cursors){
            private int _count = 0;

            @Override
            protected void handleEvents(String json) throws Exception {
                ++this._count;
                this.logDebug(this._count + ": " + json);
            }

            @Override
            protected void logDebug(String message) {
                System.out.println(message);
            }

            @Override
            protected void logInfo(String message) {
                System.out.println(Example.ANSI_GREEN + message + Example.ANSI_RESET);
            }

            @Override
            protected void logError(Exception e) {
                System.err.println(Example.ANSI_RED);
                e.printStackTrace(System.err);
                System.err.println(Example.ANSI_RESET);
            }
        };
        straw.start();
    }
}

