/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.switchboard.Answer;
import org.zalando.switchboard.Deliverable;
import org.zalando.switchboard.DeliveryMode;
import org.zalando.switchboard.LockSupport;
import org.zalando.switchboard.Subscription;
import org.zalando.switchboard.SubscriptionMode;
import org.zalando.switchboard.Switchboard;
import org.zalando.switchboard.Timeout;

final class DefaultSwitchboard
implements Switchboard {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSwitchboard.class);
    private final Queue<Deliverable> recorded = new ConcurrentLinkedQueue<Deliverable>();
    private final Queue<Answer> answers = new ConcurrentLinkedQueue<Answer>();
    private final LockSupport lock = new LockSupport();

    DefaultSwitchboard() {
    }

    @Override
    public <T, H> List<H> inspect(Class<T> messageType, Class<H> hintType) {
        return ImmutableList.copyOf(this.answers).stream().filter(delivery -> messageType.isAssignableFrom(delivery.getMessageType())).map(delivery -> this.cast(delivery.getHint())).map(hint -> hint.filter(hintType::isInstance).orElse(null)).collect(Collectors.toList());
    }

    private <H> Optional<H> cast(Optional hint) {
        return hint;
    }

    private <T, R> List<Answer<T, R, ?>> find(Deliverable<T> deliverable) {
        return this.answers.stream().filter(input -> input.test(deliverable.getMessage())).map(this::cast).collect(Collectors.toList());
    }

    @Override
    public <T> void send(Deliverable<T> deliverable) {
        this.deliver(deliverable);
    }

    private <T, R> void deliver(Deliverable<T> deliverable) {
        this.lock.transactional(() -> {
            List matches = this.find(deliverable);
            if (matches.isEmpty()) {
                this.recorded.add(deliverable);
            } else {
                DeliveryMode deliveryMode = deliverable.getDeliveryMode();
                this.deliverTo(deliveryMode.distribute(matches), deliverable);
            }
        });
    }

    private <T, R> Answer<T, R, ?> cast(Answer answer) {
        return answer;
    }

    private <T, R> void deliverTo(List<Answer<T, R, ?>> list, Deliverable<T> deliverable) {
        for (Answer<T, R, ?> answer : list) {
            answer.deliver(deliverable);
            LOG.info("Successfully matched message [{}] to [{}]", deliverable.getMessage(), answer);
        }
    }

    <T, R> void unregister(Answer<T, R, ?> answer) {
        if (this.answers.remove(answer)) {
            LOG.trace("Unregistered [{}].", answer);
        }
    }

    @Override
    public <T, R, X extends Exception> R receive(Subscription<T, ?> subscription, SubscriptionMode<T, R, X> mode, Timeout timeout) throws X, InterruptedException {
        try {
            Future future = this.subscribe((Subscription)subscription, (SubscriptionMode)mode);
            return mode.block(future, timeout.getValue(), timeout.getUnit());
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public <T, R, X extends Exception> Answer<T, R, ?> subscribe(Subscription<T, ?> subscription, SubscriptionMode<T, R, X> mode) {
        Answer answer = new Answer(subscription, mode, this::unregister);
        this.registerForFutureMessages(answer);
        this.tryDeliverRecordedMessages(answer);
        return answer;
    }

    private <T, R> void registerForFutureMessages(Answer<T, R, ?> answer) {
        this.lock.transactional(() -> {
            Preconditions.checkState((!this.answers.contains(answer) ? 1 : 0) != 0, (String)"[%s] is already registered", (Object[])new Object[]{answer});
            this.answers.add(answer);
            LOG.trace("Registered [{}]", (Object)answer);
        });
    }

    private <T, R> void tryDeliverRecordedMessages(Answer<T, R, ?> answer) {
        Optional<Deliverable<T>> match;
        while (!answer.isDone() && (match = this.findAndRemove(answer)).isPresent()) {
            Deliverable<T> deliverable = match.get();
            this.send(deliverable);
            T message = deliverable.getMessage();
            LOG.info("Successfully matched previously unhandled message [{}] to [{}]", message, answer);
        }
    }

    private <T, R> Optional<Deliverable<T>> findAndRemove(Answer<T, R, ?> answer) {
        return this.lock.transactional(() -> {
            Optional<Deliverable> first = this.recorded.stream().filter(deliverable -> answer.test(deliverable.getMessage())).map(this::cast).findFirst();
            if (first.isPresent()) {
                this.recorded.remove(first.get());
            }
            return first;
        });
    }

    private <T> Deliverable<T> cast(Deliverable deliverable) {
        return deliverable;
    }
}

