/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

final class LockSupport {
    private final Lock lock = new ReentrantLock();

    LockSupport() {
    }

    void transactional(Runnable task) {
        this.lock.lock();
        try {
            task.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    <T> T transactional(Supplier<T> task) {
        this.lock.lock();
        try {
            T t = task.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

