/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.zalando.switchboard.SimpleSubscription;
import org.zalando.switchboard.TypeResolver;

@FunctionalInterface
@Immutable
public interface Subscription<E, H>
extends Predicate<E> {
    default public Class<E> getMessageType() {
        return TypeResolver.resolve(this, Subscription.class, 0);
    }

    @Override
    public boolean test(@Nonnull E var1);

    default public Optional<H> getHint() {
        return Optional.empty();
    }

    public static <E, H> Subscription<E, H> on(Class<E> messageType, Predicate<E> predicate) {
        return new SimpleSubscription(messageType, predicate, Optional.empty());
    }

    public static <E, H> Subscription<E, H> on(Class<E> messageType, Predicate<E> predicate, H hint) {
        return new SimpleSubscription<E, H>(messageType, predicate, Optional.of(hint));
    }
}

