/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.zalando.switchboard.AtLeast;
import org.zalando.switchboard.AtLeastOnce;
import org.zalando.switchboard.AtMost;
import org.zalando.switchboard.ExactlyOnce;
import org.zalando.switchboard.Never;
import org.zalando.switchboard.Times;

public interface SubscriptionMode<T, R, X extends Exception> {
    default public boolean requiresTimeout() {
        return false;
    }

    public R block(Future<R> var1, long var2, TimeUnit var4) throws X, ExecutionException, InterruptedException;

    public boolean isDone(int var1);

    public boolean isSuccess(int var1);

    public R collect(List<T> var1);

    public static <S> SubscriptionMode<S, Void, RuntimeException> never() {
        return new Never();
    }

    public static <S> SubscriptionMode<S, List<S>, RuntimeException> atMost(int count) {
        return new AtMost(count);
    }

    public static <S> SubscriptionMode<S, S, TimeoutException> exactlyOnce() {
        return new ExactlyOnce();
    }

    public static <S> SubscriptionMode<S, List<S>, TimeoutException> times(int count) {
        return new Times(count);
    }

    public static <S> SubscriptionMode<S, S, TimeoutException> atLeastOnce() {
        return new AtLeastOnce();
    }

    public static <S> SubscriptionMode<S, List<S>, TimeoutException> atLeast(int count) {
        return new AtLeast(count);
    }
}

