/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.zalando.switchboard.Deliverable;
import org.zalando.switchboard.LockSupport;
import org.zalando.switchboard.Subscription;
import org.zalando.switchboard.SubscriptionMode;

final class Answer<T, R, H>
implements Future<R>,
Predicate<Object> {
    private final AtomicReference<State> state = new AtomicReference<State>(State.WAITING);
    private final Subscription<T, H> subscription;
    private final SubscriptionMode<T, R> mode;
    private final Consumer<Answer<T, R, H>> unregister;
    private final BlockingQueue<Deliverable<T>> queue = new LinkedBlockingQueue<Deliverable<T>>();
    private final AtomicInteger delivered = new AtomicInteger();
    private final LockSupport lock = new LockSupport();

    Answer(Subscription<T, H> subscription, SubscriptionMode<T, R> mode, Consumer<Answer<T, R, H>> unregister) {
        this.subscription = subscription;
        this.mode = mode;
        this.unregister = unregister;
    }

    Class<T> getMessageType() {
        return this.subscription.getMessageType();
    }

    Optional<H> getHint() {
        return this.subscription.getHint();
    }

    @Override
    public boolean test(@Nullable Object input) {
        return this.subscription.getMessageType().isInstance(input) && this.subscription.test(this.cast(input));
    }

    private T cast(Object input) {
        return (T)input;
    }

    void deliver(Deliverable<T> deliverable) {
        this.lock.transactional(() -> {
            this.queue.add(deliverable);
            if (this.mode.isDone(this.delivered.incrementAndGet())) {
                this.finish(State.DONE);
            }
        });
    }

    private boolean finish(State endState) {
        this.unregister();
        return this.state.compareAndSet(State.WAITING, endState);
    }

    private void unregister() {
        this.unregister.accept(this);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        switch (this.state.get()) {
            case WAITING: {
                return this.finish(State.CANCELLED);
            }
            case DONE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.state.get() == State.CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.state.get() != State.WAITING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get() throws InterruptedException, ExecutionException {
        this.checkTimeoutRequirement();
        try {
            ArrayList results = new ArrayList();
            int received = 0;
            while (!this.mode.isDone(received)) {
                Deliverable<T> deliverable = this.queue.take();
                this.deliver(results, deliverable);
                ++received;
            }
            R r = this.verifyAndTransform(results, received, this::message);
            return r;
        }
        finally {
            this.unregister();
        }
    }

    private void checkTimeoutRequirement() {
        Preconditions.checkArgument((!this.mode.requiresTimeout() ? 1 : 0) != 0, (String)"Mode %s requires a timeout", (Object[])new Object[]{this.mode.getClass().getSimpleName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get(long timeout, TimeUnit timeoutUnit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            ArrayList results = new ArrayList();
            int received = 0;
            long deadline = System.nanoTime() + timeoutUnit.toNanos(timeout);
            while (!this.mode.isDone(received)) {
                boolean timedOut;
                Deliverable<T> deliverable = this.queue.poll(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
                boolean bl = timedOut = deliverable == null;
                if (timedOut) {
                    this.verifyTimeout(received, timeout, timeoutUnit);
                    break;
                }
                this.deliver(results, deliverable);
                ++received;
            }
            R r = this.verifyAndTransform(results, received, count -> this.message((int)count, timeout, timeoutUnit));
            return r;
        }
        finally {
            this.unregister();
        }
    }

    private void deliver(List<T> results, Deliverable<T> deliverable) throws ExecutionException {
        deliverable.deliverTo(results);
    }

    private R verifyAndTransform(List<T> results, int received, Function<Integer, String> message) {
        if (this.mode.isSuccess(received)) {
            return this.mode.collect(results);
        }
        throw new IllegalStateException(message.apply(received));
    }

    private void verifyTimeout(int received, long timeout, TimeUnit timeoutUnit) throws TimeoutException {
        if (!this.mode.isSuccess(received)) {
            throw new TimeoutException(this.message(received, timeout, timeoutUnit));
        }
    }

    private String message(int received) {
        return String.format("Expected %s %s message(s), but got %d", this.mode, this.getMessageName(), received);
    }

    private String message(int received, long timeout, TimeUnit timeoutUnit) {
        return String.format("Expected %s %s message(s), but got %d in %d %s", this.mode, this.getMessageName(), received, timeout, this.humanize(timeoutUnit));
    }

    private String getMessageName() {
        return this.subscription.getMessageType().getSimpleName();
    }

    private String humanize(TimeUnit timeoutUnit) {
        return timeoutUnit.name().toLowerCase(Locale.ENGLISH);
    }

    public int hashCode() {
        return Objects.hash(this.subscription);
    }

    public boolean equals(@Nullable Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Answer) {
            Answer other = (Answer)that;
            return Objects.equals(this.subscription, other.subscription);
        }
        return false;
    }

    public String toString() {
        return this.subscription.toString();
    }

    static enum State {
        WAITING,
        DONE,
        CANCELLED;

    }
}

