/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.zalando.switchboard.SubscriptionMode;

final class AtLeast<S>
implements SubscriptionMode<S, List<S>> {
    private final int count;

    public AtLeast(int count) {
        this.count = count;
    }

    @Override
    public List<S> block(Future<List<S>> future, long timeout, TimeUnit timeoutUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.get(timeout, timeoutUnit);
    }

    @Override
    public boolean isDone(int received) {
        return received >= this.count;
    }

    @Override
    public boolean isSuccess(int received) {
        return received >= this.count;
    }

    @Override
    public List<S> collect(List<S> results) {
        return results;
    }

    public String toString() {
        return "at least " + this.count;
    }
}

