/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.zalando.switchboard.DeliveryMode;
import org.zalando.switchboard.Failure;
import org.zalando.switchboard.Message;

public interface Deliverable<T> {
    public void deliverTo(Collection<? super T> var1) throws ExecutionException;

    public T getMessage();

    public DeliveryMode getDeliveryMode();

    public static <T> Deliverable<T> message(T message, DeliveryMode mode) {
        return new Message<T>(message, mode);
    }

    public static <T> Deliverable<T> failure(T message, DeliveryMode mode, Throwable throwable) {
        return new Failure<T>(message, mode, throwable);
    }
}

