/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.zalando.switchboard.SubscriptionMode;

final class ExactlyOnce<S>
implements SubscriptionMode<S, S> {
    ExactlyOnce() {
    }

    @Override
    public boolean requiresTimeout() {
        return true;
    }

    @Override
    public S block(Future<S> future, long timeout, TimeUnit timeoutUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.get(timeout, timeoutUnit);
    }

    @Override
    public boolean isDone(int received) {
        return received > 1;
    }

    @Override
    public boolean isSuccess(int received) {
        return received == 1;
    }

    @Override
    public S collect(List<S> results) {
        return results.get(0);
    }

    public String toString() {
        return "exactly one";
    }
}

