/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.switchboard;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.zalando.switchboard.AtLeast;
import org.zalando.switchboard.AtLeastOnce;
import org.zalando.switchboard.AtMost;
import org.zalando.switchboard.ExactlyOnce;
import org.zalando.switchboard.Never;
import org.zalando.switchboard.Times;

public interface SubscriptionMode<T, R> {
    default public boolean requiresTimeout() {
        return false;
    }

    public R block(Future<R> var1, long var2, TimeUnit var4) throws ExecutionException, TimeoutException, InterruptedException;

    public boolean isDone(int var1);

    public boolean isSuccess(int var1);

    public R collect(List<T> var1);

    public static <S> SubscriptionMode<S, Void> never() {
        return new Never();
    }

    public static <S> SubscriptionMode<S, List<S>> atMost(int count) {
        return new AtMost(count);
    }

    public static <S> SubscriptionMode<S, S> exactlyOnce() {
        return new ExactlyOnce();
    }

    public static <S> SubscriptionMode<S, List<S>> times(int count) {
        return new Times(count);
    }

    public static <S> SubscriptionMode<S, S> atLeastOnce() {
        return new AtLeastOnce();
    }

    public static <S> SubscriptionMode<S, List<S>> atLeast(int count) {
        return new AtLeast(count);
    }
}

