/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.test.kit.service;

import com.opentable.db.postgres.embedded.EmbeddedPostgreSQL;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.test.kit.service.DatabaseTestServiceConfig;
import org.zalando.test.kit.service.TestService;
import org.zalando.test.kit.service.TestService$class;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u00015\u00111\u0003R1uC\n\f7/\u001a+fgR\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\u0004W&$(BA\u0004\t\u0003\u0011!Xm\u001d;\u000b\u0005%Q\u0011a\u0002>bY\u0006tGm\u001c\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\u0006UKN$8+\u001a:wS\u000e,\u0007\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\r\r|gNZ5h+\u0005Y\u0002CA\u000b\u001d\u0013\ti\"AA\rECR\f'-Y:f)\u0016\u001cHoU3sm&\u001cWmQ8oM&<\u0007\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000f\r|gNZ5hA!)\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"a\t\u0013\u0011\u0005U\u0001\u0001\"B\r!\u0001\u0004Y\u0002\"\u0002\u0014\u0001\t\u0003:\u0013\u0001\u00028b[\u0016,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA\u0001\\1oO*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018+\u0005\u0019\u0019FO]5oO\"9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0014A\u00027pO\u001e,'/F\u00014!\t!t'D\u00016\u0015\t1$\"A\u0003tY\u001a$$.\u0003\u00029k\t1Aj\\4hKJDaA\u000f\u0001!\u0002\u0013\u0019\u0014a\u00027pO\u001e,'\u000f\t\u0005\ny\u0001\u0001\r\u00111A\u0005\u0002u\n!\u0001]4\u0016\u0003y\u0002\"a\u0010&\u000e\u0003\u0001S!!\u0011\"\u0002\u0011\u0015l'-\u001a3eK\u0012T!a\u0011#\u0002\u0011A|7\u000f^4sKNT!!\u0012$\u0002\u0005\u0011\u0014'BA$I\u0003%y\u0007/\u001a8uC\ndWMC\u0001J\u0003\r\u0019w.\\\u0005\u0003\u0017\u0002\u0013!#R7cK\u0012$W\r\u001a)pgR<'/Z*R\u0019\"IQ\n\u0001a\u0001\u0002\u0004%\tAT\u0001\u0007a\u001e|F%Z9\u0015\u0005=\u0013\u0006CA\bQ\u0013\t\t\u0006C\u0001\u0003V]&$\bbB*M\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\n\u0004BB+\u0001A\u0003&a(A\u0002qO\u0002BQa\u0016\u0001\u0005\u0002a\u000bQa\u001d;beR$\u0012a\u0014\u0005\u00065\u0002!\t\u0001W\u0001\u0005gR|\u0007\u000fC\u0003]\u0001\u0011%\u0001,\u0001\bueVt7-\u0019;f)\u0006\u0014G.Z:\t\u000by\u0003A\u0011\t-\u0002\u0017\t,gm\u001c:f'VLG/\u001a\u0005\u0006A\u0002!\t\u0005W\u0001\u000bC\u001a$XM]*vSR,\u0007\"\u00022\u0001\t\u0003B\u0016A\u00032fM>\u0014X\rV3ti\")A\r\u0001C\u0001K\u0006aQ\r_3dkR,\u0017+^3ssR\u0011a-\u001d\t\u0004O2tW\"\u00015\u000b\u0005%T\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003WB\t!bY8mY\u0016\u001cG/[8o\u0013\ti\u0007NA\u0002TKF\u0004\"aD8\n\u0005A\u0004\"a\u0002(pi\"Lgn\u001a\u0005\u0006e\u000e\u0004\ra]\u0001\u0006cV,'/\u001f\t\u0003i^t!aD;\n\u0005Y\u0004\u0012A\u0002)sK\u0012,g-\u0003\u00020q*\u0011a\u000f\u0005\u0005\u0006u\u0002!\ta_\u0001\u0012Kb,7-\u001e;f\u0007>,h\u000e^)vKJLHC\u0001?\u0000!\tyQ0\u0003\u0002\u007f!\t\u0019\u0011J\u001c;\t\r\u0005\u0005\u0011\u00101\u0001t\u0003)\u0019w.\u001e8u#V,'/\u001f")
public class DatabaseTestService
implements TestService {
    private final DatabaseTestServiceConfig config;
    private final Logger logger;
    private EmbeddedPostgreSQL pg;

    @Override
    public void afterTest() {
        TestService$class.afterTest(this);
    }

    public DatabaseTestServiceConfig config() {
        return this.config;
    }

    @Override
    public String name() {
        return "Postgres Database";
    }

    private Logger logger() {
        return this.logger;
    }

    public EmbeddedPostgreSQL pg() {
        return this.pg;
    }

    public void pg_$eq(EmbeddedPostgreSQL x$1) {
        this.pg = x$1;
    }

    public void start() {
        this.pg_$eq(EmbeddedPostgreSQL.builder().setPort(this.config().port()).start());
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " started at port ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.pg().getPort())})));
    }

    public void stop() {
        this.pg().close();
        this.logger().info("{} stopped", new Object[]{this.name()});
    }

    /*
     * WARNING - void declaration
     */
    private void truncateTables() {
        Connection con = this.pg().getPostgresDatabase().getConnection();
        BufferedReader br = new BufferedReader(new FileReader(this.config().truncateScript()));
        String str = null;
        StringBuffer sb = new StringBuffer();
        while (true) {
            void var3_3;
            void var4_4;
            if ((str = br.readLine()) == null) {
                Statement statement = con.createStatement();
                statement.execute(sb.toString());
                statement.close();
                con.close();
                this.logger().debug(new StringBuilder().append((Object)"Database tables truncated: ").append((Object)sb.toString()).toString());
                return;
            }
            var4_4.append(new StringBuilder().append((Object)var3_3).append((Object)"\n ").toString());
        }
    }

    @Override
    public void beforeSuite() {
        this.start();
    }

    @Override
    public void afterSuite() {
        this.stop();
    }

    @Override
    public void beforeTest() {
        this.truncateTables();
    }

    public scala.collection.mutable.Seq<Nothing$> executeQuery(String query) {
        Connection con = this.pg().getPostgresDatabase().getConnection();
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery(query);
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        scala.collection.mutable.Seq resultList = (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (rs.next()) {
            Map row = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), columns).foreach((Function1)new Serializable(this, rs, md, row){
                public static final long serialVersionUID = 0L;
                private final ResultSet rs$1;
                private final ResultSetMetaData md$1;
                private final Map row$1;

                public final Map<String, Object> apply(int i) {
                    return (Map)this.row$1.$plus$eq(new Tuple2((Object)this.md$1.getColumnName(i), this.rs$1.getObject(i)));
                }
                {
                    this.rs$1 = rs$1;
                    this.md$1 = md$1;
                    this.row$1 = row$1;
                }
            });
            resultList.$plus$plus((GenTraversableOnce)row, Seq$.MODULE$.canBuildFrom());
        }
        rs.close();
        statement.closeOnCompletion();
        con.close();
        return resultList;
    }

    public int executeCountQuery(String countQuery) {
        Connection con = this.pg().getPostgresDatabase().getConnection();
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery(countQuery);
        int countResult = rs.getInt(1);
        rs.close();
        statement.closeOnCompletion();
        con.close();
        return countResult;
    }

    public DatabaseTestService(DatabaseTestServiceConfig config) {
        this.config = config;
        TestService$class.$init$(this);
        this.logger = LoggerFactory.getLogger(DatabaseTestService.class);
    }
}

