/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.test.kit.service;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import org.zalando.test.kit.TestServiceException;
import org.zalando.test.kit.service.DockerContainerConfig;
import org.zalando.test.kit.service.DockerContainerTestService$;
import org.zalando.test.kit.service.PortBindingConfig;
import org.zalando.test.kit.service.ReadinessNotifier;
import org.zalando.test.kit.service.SharedFolderConfig;
import org.zalando.test.kit.service.TestService;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0001\u0003\u00015\u0011!\u0004R8dW\u0016\u00148i\u001c8uC&tWM\u001d+fgR\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\u0004W&$(BA\u0004\t\u0003\u0011!Xm\u001d;\u000b\u0005%Q\u0011a\u0002>bY\u0006tGm\u001c\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\f)\u0016\u001cHoU3sm&\u001cW\r\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0011!\u0019\u0003A!b\u0001\n\u0003\"\u0013\u0001\u00028b[\u0016,\u0012!\n\t\u0003M5r!aJ\u0016\u0011\u0005!\u0002R\"A\u0015\u000b\u0005)b\u0011A\u0002\u001fs_>$h(\u0003\u0002-!\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0003\u0003\u0003\u00052\u0001\t\u0005\t\u0015!\u0003&\u0003\u0015q\u0017-\\3!\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0013AE5nC\u001e,g*Y7f'V\u00147\u000f\u001e:j]\u001eD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0014S6\fw-\u001a(b[\u0016\u001cVOY:ue&tw\r\t\u0005\to\u0001\u0011)\u0019!C\u0001I\u0005aAm\\2lKJ\f\u0005/[+sS\"A\u0011\b\u0001B\u0001B\u0003%Q%A\u0007e_\u000e\\WM]!qSV\u0013\u0018\u000e\t\u0005\tw\u0001\u0011)\u0019!C\u0001y\u0005a\u0001o\u001c:u\u0005&tG-\u001b8hgV\tQ\bE\u0002'}\u0001K!aP\u0018\u0003\u0007M+G\u000f\u0005\u0002\u0016\u0003&\u0011!I\u0001\u0002\u0012!>\u0014HOQ5oI&twmQ8oM&<\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u001bA|'\u000f\u001e\"j]\u0012LgnZ:!\u0011!1\u0005A!b\u0001\n\u00039\u0015!D:iCJ,GMR8mI\u0016\u00148/F\u0001I!\r1c(\u0013\t\u0003+)K!a\u0013\u0002\u0003%MC\u0017M]3e\r>dG-\u001a:D_:4\u0017n\u001a\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0011\u0006q1\u000f[1sK\u00124u\u000e\u001c3feN\u0004\u0003\u0002C(\u0001\u0005\u000b\u0007I\u0011\u0001)\u0002)\r|W.\\1oI2Kg.Z!sOVlWM\u001c;t+\u0005\t\u0006c\u0001*XK9\u00111+\u0016\b\u0003QQK\u0011!E\u0005\u0003-B\tq\u0001]1dW\u0006<W-\u0003\u0002Y3\n\u00191+Z9\u000b\u0005Y\u0003\u0002\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002+\r|W.\\1oI2Kg.Z!sOVlWM\u001c;tA!AQ\f\u0001BC\u0002\u0013\u0005a,A\tsK\u0006$\u0017N\\3tg:{G/\u001b4jKJ,\u0012a\u0018\t\u0003+\u0001L!!\u0019\u0002\u0003#I+\u0017\rZ5oKN\u001chj\u001c;jM&,'\u000f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003`\u0003I\u0011X-\u00193j]\u0016\u001c8OT8uS\u001aLWM\u001d\u0011\t\u000b\u0015\u0004A\u0011\u00014\u0002\rqJg.\u001b;?)!9\u0007.\u001b6lY6t\u0007CA\u000b\u0001\u0011\u0015\u0019C\r1\u0001&\u0011\u0015\u0019D\r1\u0001&\u0011\u00159D\r1\u0001&\u0011\u001dYD\r%AA\u0002uBqA\u00123\u0011\u0002\u0003\u0007\u0001\nC\u0004PIB\u0005\t\u0019A)\t\u000fu#\u0007\u0013!a\u0001?\")Q\r\u0001C\u0001aR\u0019q-\u001d<\t\u000bI|\u0007\u0019A:\u0002\r\r|gNZ5h!\t)B/\u0003\u0002v\u0005\t)Bi\\2lKJ\u001cuN\u001c;bS:,'oQ8oM&<\u0007\"B/p\u0001\u0004yV\u0001\u0002=\u0001\u0001\u0015\u00121bQ8oi\u0006Lg.\u001a:JI\"9!\u0010\u0001a\u0001\n\u0013Y\u0018!B:uCR,W#\u0001?\u0011\u000bu\f\t!!\u0002\u000e\u0003yT!a \t\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u0007q(a\u0001+ssBIq\"a\u0002\u0002\f\u0005}\u00111E\u0005\u0004\u0003\u0013\u0001\"A\u0002+va2,7\u0007\u0005\u0003\u0002\u000e\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0016\u0005]\u0011A\u00033pG.,'O[1wC*\u0019\u0011\u0011\u0004\u0010\u0002\r\u001dLG\u000f[;c\u0013\u0011\ti\"a\u0004\u0003\u0019\u0011{7m[3s\u00072LWM\u001c;\u0011\u0007\u0005\u0005r/D\u0001\u0001!\u0019\t)#a\u000b\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\ty!A\u0003bgft7-\u0003\u0003\u0002.\u0005\u001d\"A\u0004*fgVdGoQ1mY\n\f7m\u001b\t\u0005\u0003c\t9$\u0004\u0002\u00024)!\u0011QGA\b\u0003\u0015iw\u000eZ3m\u0013\u0011\tI$a\r\u0003\u000b\u0019\u0013\u0018-\\3\t\u0013\u0005u\u0002\u00011A\u0005\n\u0005}\u0012!C:uCR,w\fJ3r)\u0011\t\t%a\u0012\u0011\u0007=\t\u0019%C\u0002\u0002FA\u0011A!\u00168ji\"I\u0011\u0011JA\u001e\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\n\u0004bBA'\u0001\u0001\u0006K\u0001`\u0001\u0007gR\fG/\u001a\u0011\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u0005)1\u000f^1siR\u0011\u0011\u0011\t\u0005\b\u0003/\u0002A\u0011AA*\u0003\u0015\u0011Xm]3u\u0011\u001d\tY\u0006\u0001C\u0005\u0003;\n!c\u0019:fCR,Gi\\2lKJ\u001cE.[3oiV\u0011\u0011q\f\t\u0006{\u0006\u0005\u00111\u0002\u0005\b\u0003G\u0002A\u0011BA3\u0003Q\u0019H/\u0019:u\t>\u001c7.\u001a:D_:$\u0018-\u001b8feRa\u0011qMA5\u0003[\n\t(!\u001e\u0002xA)Q0!\u0001\u0002 !A\u00111NA1\u0001\u0004\tY!\u0001\u0004dY&,g\u000e\u001e\u0005\b\u0003_\n\t\u00071\u0001&\u0003%IW.Y4f\u001d\u0006lW\rC\u0004\u0002t\u0005\u0005\u0004\u0019A\u0013\u0002\u0015\u0015DHO]1I_N$8\u000f\u0003\u0004<\u0003C\u0002\r!\u0010\u0005\u0007\r\u0006\u0005\u0004\u0019\u0001%\t\u000f\u0005m\u0004\u0001\"\u0005\u0002~\u0005\u0001R.Y6f\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u000b\u0004K\u0005}\u0004bBAA\u0003s\u0002\r!J\u0001\u0017C\n\u001cx\u000e\\;uK>\u0013(+\u001a7bi&4X\rU1uQ\"1\u0011Q\u0011\u0001\u0005\n\u0011\nA\u0002Z8dW\u0016\u0014\bj\\:u\u0013BDq!!#\u0001\t\u0013\tY)A\u0006j]R,'OZ1dK&\u0003H\u0003BAG\u0003'\u0003BaDAHK%\u0019\u0011\u0011\u0013\t\u0003\r=\u0003H/[8o\u0011\u001d\t)*a\"A\u0002\u0015\nAC\\3uo>\u00148.\u00138uKJ4\u0017mY3OC6,\u0007bBAM\u0001\u0011%\u00111T\u0001\u0010CR$\u0018m\u00195D_:$\u0018-\u001b8feR1\u0011QTAP\u0003C\u0003R!`A\u0001\u0003GA\u0001\"a\u001b\u0002\u0018\u0002\u0007\u00111\u0002\u0005\t\u0003G\u000b9\n1\u0001\u0002 \u0005Y1m\u001c8uC&tWM]%e\u0011\u001d\t9\u000b\u0001C\u0005\u0003S\u000bqCZ5oI6{7\u000f\u001e*fG\u0016tG/S7bO\u0016t\u0015-\\3\u0015\r\u0005-\u0016QVAX!\u0011i\u0018\u0011A\u0013\t\u0011\u0005-\u0014Q\u0015a\u0001\u0003\u0017Aq!!-\u0002&\u0002\u0007Q%A\u0005tk\n\u001cHO]5oO\"9\u0011Q\u0017\u0001\u0005\u0002\u0005M\u0013\u0001B:u_B<\u0011\"!/\u0003\u0003\u0003E\t!a/\u00025\u0011{7m[3s\u0007>tG/Y5oKJ$Vm\u001d;TKJ4\u0018nY3\u0011\u0007U\tiL\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA`'\r\tiL\u0004\u0005\bK\u0006uF\u0011AAb)\t\tY\f\u0003\u0006\u0002H\u0006u\u0016\u0013!C\u0001\u0003\u0013\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAAfU\ri\u0014QZ\u0016\u0003\u0003\u001f\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001c\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002^\u0006M'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011\u0011]A_#\u0003%\t!a9\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t)OK\u0002I\u0003\u001bD!\"!;\u0002>F\u0005I\u0011AAv\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011Q\u001e\u0016\u0004#\u00065\u0007BCAy\u0003{\u000b\n\u0011\"\u0001\u0002t\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"!!>+\u0007}\u000bi\r")
public class DockerContainerTestService
implements TestService,
StrictLogging {
    private final String name;
    private final String imageNameSubstring;
    private final String dockerApiUri;
    private final Set<PortBindingConfig> portBindings;
    private final Set<SharedFolderConfig> sharedFolders;
    private final Seq<String> commandLineArguments;
    private final ReadinessNotifier readinessNotifier;
    private Try<Tuple3<DockerClient, String, ResultCallback<Frame>>> state;
    private final Logger logger;

    public static ReadinessNotifier $lessinit$greater$default$7() {
        return DockerContainerTestService$.MODULE$.$lessinit$greater$default$7();
    }

    public static Seq<String> $lessinit$greater$default$6() {
        return DockerContainerTestService$.MODULE$.$lessinit$greater$default$6();
    }

    public static Set<SharedFolderConfig> $lessinit$greater$default$5() {
        return DockerContainerTestService$.MODULE$.$lessinit$greater$default$5();
    }

    public static Set<PortBindingConfig> $lessinit$greater$default$4() {
        return DockerContainerTestService$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public void beforeSuite() {
        TestService.beforeSuite$(this);
    }

    @Override
    public void beforeTest() {
        TestService.beforeTest$(this);
    }

    @Override
    public void afterTest() {
        TestService.afterTest$(this);
    }

    @Override
    public void afterSuite() {
        TestService.afterSuite$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String imageNameSubstring() {
        return this.imageNameSubstring;
    }

    public String dockerApiUri() {
        return this.dockerApiUri;
    }

    public Set<PortBindingConfig> portBindings() {
        return this.portBindings;
    }

    public Set<SharedFolderConfig> sharedFolders() {
        return this.sharedFolders;
    }

    public Seq<String> commandLineArguments() {
        return this.commandLineArguments;
    }

    public ReadinessNotifier readinessNotifier() {
        return this.readinessNotifier;
    }

    private Try<Tuple3<DockerClient, String, ResultCallback<Frame>>> state() {
        return this.state;
    }

    private void state_$eq(Try<Tuple3<DockerClient, String, ResultCallback<Frame>>> x$1) {
        this.state = x$1;
    }

    public void start() {
        this.state_$eq((Try<Tuple3<DockerClient, String, ResultCallback<Frame>>>)this.createDockerClient().flatMap((Function1 & Serializable & scala.Serializable)client -> this.findMostRecentImageName((DockerClient)client, this.imageNameSubstring()).flatMap((Function1 & Serializable & scala.Serializable)imageName -> this.startDockerContainer((DockerClient)client, (String)imageName, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dockerhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dockerHostIp()})), this.portBindings(), this.sharedFolders()).flatMap((Function1 & Serializable & scala.Serializable)containerId -> this.attachContainer((DockerClient)client, (String)containerId).map((Function1 & Serializable & scala.Serializable)attachedStream -> new Tuple3(client, containerId, attachedStream))))));
        this.state().failed().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            throw x$1;
        });
    }

    public void reset() {
    }

    private Try<DockerClient> createDockerClient() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DockerClientBuilder.getInstance((DockerClientConfig)DockerClientConfig.createDefaultConfigBuilder().withUri(this.dockerApiUri()).build()).build());
    }

    private Try<String> startDockerContainer(DockerClient client, String imageName, String extraHosts, Set<PortBindingConfig> portBindings, Set<SharedFolderConfig> sharedFolders) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            CreateContainerCmd createContainerCmd = client.createContainerCmd(imageName).withExposedPorts((ExposedPort[])((SetLike)portBindings.map((Function1 & Serializable & scala.Serializable)binding -> ExposedPort.tcp((int)binding.internal()), Set$.MODULE$.canBuildFrom())).toSeq().toArray(ClassTag$.MODULE$.apply(ExposedPort.class))).withExtraHosts(new String[]{extraHosts});
            Ports bindings = new Ports();
            portBindings.foreach((Function1 & Serializable & scala.Serializable)binding -> {
                bindings.bind(ExposedPort.tcp((int)binding.internal()), Ports.Binding((Integer)Predef$.MODULE$.int2Integer(binding.external())));
                return BoxedUnit.UNIT;
            });
            String containerId = createContainerCmd.withPortBindings(bindings).withCmd((String[])this.commandLineArguments().toArray(ClassTag$.MODULE$.apply(String.class))).withBinds((Bind[])((SetLike)sharedFolders.map((Function1 & Serializable & scala.Serializable)sharedFolderConfig -> new Bind(this.makeAbsolutePath(sharedFolderConfig.external()), new Volume(sharedFolderConfig.internal())), Set$.MODULE$.canBuildFrom())).toSeq().toArray(ClassTag$.MODULE$.apply(Bind.class))).exec().getId();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting docker container: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{imageName})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            client.startContainerCmd(containerId).exec();
            Predef$.MODULE$.assert(client.inspectContainerCmd(containerId).exec().getState().isRunning());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Docker container ", " started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerId})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return containerId;
        });
    }

    public String makeAbsolutePath(String absoluteOrRelativePath) {
        String string;
        if (new File(absoluteOrRelativePath).exists()) {
            string = absoluteOrRelativePath;
        } else {
            Option maybeFile = Option$.MODULE$.apply((Object)this.getClass().getResource(absoluteOrRelativePath)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getFile());
            if (maybeFile.isEmpty()) {
                throw new TestServiceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find absolute path for: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absoluteOrRelativePath})));
            }
            string = (String)maybeFile.get();
        }
        return string;
    }

    private String dockerHostIp() {
        String ip;
        Option option = this.interfaceIp("docker0").orElse((Function0 & Serializable & scala.Serializable)() -> this.interfaceIp("vboxnet0")).orElse((Function0 & Serializable & scala.Serializable)() -> this.interfaceIp("vboxnet1"));
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ip = (String)some.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected docker host IP (", "). It will be reachable from inside the container by domain name 'dockerhost'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ip})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new TestServiceException("Failed to determine docker host IP by searching for a docker0, vboxnet0 or vboxnet1 network interface");
        }
        String string = ip;
        return string;
    }

    private Option<String> interfaceIp(String networkInterfaceName) {
        return ((TraversableLike)((List)((TraversableLike)((List)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toList().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DockerContainerTestService.$anonfun$interfaceIp$1(networkInterfaceName, x$3)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(x$4.getInetAddresses()).asScala()).toList(), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DockerContainerTestService.$anonfun$interfaceIp$3(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getHostAddress(), List$.MODULE$.canBuildFrom())).headOption();
    }

    private Try<ResultCallback<Frame>> attachContainer(DockerClient client, String containerId) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            AttachContainerResultCallback callback = new AttachContainerResultCallback(this){
                private final /* synthetic */ DockerContainerTestService $outer;

                public void onNext(Frame frame) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isInfoEnabled()) {
                        this.$outer.logger().underlying().info("\n> {}", new Object[]{new String(frame.getPayload()).trim()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }

                public void onError(Throwable throwable) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isErrorEnabled()) {
                        this.$outer.logger().underlying().error("Error from docker container", throwable);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            AttachContainerResultCallback resultCallback = (AttachContainerResultCallback)client.attachContainerCmd(containerId).withStdErr().withStdOut().withFollowStream().withLogs().exec((ResultCallback)callback);
            this.readinessNotifier().awaitReady(this.readinessNotifier().awaitReady$default$1());
            return resultCallback;
        });
    }

    private Try<String> findMostRecentImageName(DockerClient client, String substring) {
        Option option = ((TraversableLike)((List)((SeqLike)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((java.util.List)client.listImagesCmd().exec()).iterator()).asScala()).toList().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DockerContainerTestService.$anonfun$findMostRecentImageName$1(substring, x$7)))).sortWith((Function2 & Serializable & scala.Serializable)(image1, image2) -> BoxesRunTime.boxToBoolean((boolean)DockerContainerTestService.$anonfun$findMostRecentImageName$2(image1, image2)))).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$8.getRepoTags())), List$.MODULE$.canBuildFrom())).headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                Failure failure;
                Failure failure2 = failure;
                Failure failure3 = failure;
                throw new TestServiceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"At least one docker image (", ") has to be published locally"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.imageNameSubstring()})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String string = (String)some.value();
        Success success = new Success((Object)string);
        return success;
    }

    public void stop() {
        this.state().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DockerContainerTestService.$anonfun$stop$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$interfaceIp$1(String networkInterfaceName$1, NetworkInterface x$3) {
        String string = x$3.getDisplayName();
        String string2 = networkInterfaceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$interfaceIp$3(InetAddress x$5) {
        return x$5 instanceof Inet4Address;
    }

    public static final /* synthetic */ boolean $anonfun$findMostRecentImageName$1(String substring$1, Image x$7) {
        return ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7.getRepoTags())).head()).contains(substring$1);
    }

    public static final /* synthetic */ boolean $anonfun$findMostRecentImageName$2(Image image1, Image image2) {
        return Predef$.MODULE$.long2Long(image1.getCreated()).compareTo(Predef$.MODULE$.long2Long(image2.getCreated())) > 0;
    }

    public static final /* synthetic */ void $anonfun$stop$1(DockerContainerTestService $this, Tuple3 x0$1) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            DockerClient client = (DockerClient)tuple3._1();
            String id = (String)tuple3._2();
            ResultCallback attached = (ResultCallback)tuple3._3();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> attached.close());
            if (client.inspectContainerCmd(id).exec().getState().isRunning()) {
                BoxedUnit boxedUnit2;
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping docker container: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                client.stopContainerCmd(id).exec();
                client.waitContainerCmd(id).exec();
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Docker container ", " stopped"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Container ", " is not running"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public DockerContainerTestService(String name, String imageNameSubstring, String dockerApiUri, Set<PortBindingConfig> portBindings, Set<SharedFolderConfig> sharedFolders, Seq<String> commandLineArguments, ReadinessNotifier readinessNotifier) {
        this.name = name;
        this.imageNameSubstring = imageNameSubstring;
        this.dockerApiUri = dockerApiUri;
        this.portBindings = portBindings;
        this.sharedFolders = sharedFolders;
        this.commandLineArguments = commandLineArguments;
        this.readinessNotifier = readinessNotifier;
        TestService.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        this.state = new Failure((Throwable)new RuntimeException("not initialized"));
    }

    public DockerContainerTestService(DockerContainerConfig config, ReadinessNotifier readinessNotifier) {
        this((String)config.serviceName().getOrElse((Function0)new scala.Serializable(config){
            public static final long serialVersionUID = 0L;
            private final DockerContainerConfig config$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Docker container ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config$1.imageNameSubstring()}));
            }
            {
                this.config$1 = config$1;
            }
        }), config.imageNameSubstring(), config.dockerApiUri(), config.portBindings(), config.sharedFolders(), config.commandLineArguments(), readinessNotifier);
    }
}

