/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.zalando.tracer.Generator;
import org.zalando.tracer.Trace;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.Tracer;

final class DefaultTracer
implements Tracer {
    private final ImmutableMap<String, ThreadLocal<String>> traces;
    private final ImmutableMap<String, Generator> generators;
    private final ImmutableList<TraceListener> listeners;

    DefaultTracer(ImmutableMap<String, Generator> generators, ImmutableList<TraceListener> listeners) {
        this.traces = Maps.toMap((Iterable)generators.keySet(), trace -> new ThreadLocal());
        this.generators = generators;
        this.listeners = listeners;
    }

    @Override
    public void start(Function<String, String> provider) {
        this.traces.forEach((trace, state) -> {
            Preconditions.checkState((state.get() == null ? 1 : 0) != 0, (String)"%s is already started", (Object[])new Object[]{trace});
            String present = (String)provider.apply((String)trace);
            String value = Optional.ofNullable(present).orElseGet(() -> ((Generator)this.generators.get(trace)).generate());
            state.set(value);
            this.listeners.forEach(listener -> listener.onStart((String)trace, value));
        });
    }

    @Override
    public Trace get(String trace) {
        ThreadLocal<String> state = this.getAndCheckState(trace);
        return () -> this.getAndCheckValue(trace, state);
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        this.traces.forEach((trace, state) -> consumer.accept((String)trace, this.getAndCheckValue((String)trace, (ThreadLocal<String>)state)));
    }

    @Override
    public void stop() {
        this.traces.forEach((trace, state) -> {
            String value = this.getAndCheckValue((String)trace, (ThreadLocal<String>)state);
            state.remove();
            this.listeners.forEach(listener -> listener.onStop((String)trace, value));
        });
    }

    private ThreadLocal<String> getAndCheckState(String name) {
        ThreadLocal state = (ThreadLocal)this.traces.get((Object)name);
        Preconditions.checkState((state != null ? 1 : 0) != 0, (String)"No such trace: %s", (Object[])new Object[]{name});
        return state;
    }

    private String getAndCheckValue(String trace, ThreadLocal<String> state) {
        String value = state.get();
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"%s has not been started", (Object[])new Object[]{trace});
        return value;
    }
}

