/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.zalando.tracer.Generator;
import org.zalando.tracer.Trace;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.Tracer;

final class DefaultTracer
implements Tracer {
    private final ImmutableMap<String, ThreadLocal<String>> traces;
    private final ImmutableMap<String, Generator> generators;
    private final TraceListener listeners;

    DefaultTracer(ImmutableMap<String, Generator> generators, TraceListener listeners) {
        this.traces = Maps.toMap((Iterable)generators.keySet(), name -> new ThreadLocal());
        this.generators = generators;
        this.listeners = listeners;
    }

    @Override
    public void start(Function<String, String> provider) {
        this.traces.forEach((name, state) -> {
            Preconditions.checkState((state.get() == null ? 1 : 0) != 0, (String)"%s is already started", (Object[])new Object[]{name});
            String current = this.generate(provider, (String)name);
            state.set(current);
            this.listeners.onStart((String)name, current);
        });
    }

    private String generate(Function<String, String> provider, String name) {
        return Optional.ofNullable(provider.apply(name)).orElseGet(() -> ((Generator)this.generators.get((Object)name)).generate());
    }

    @Override
    public Trace get(final String name) {
        final ThreadLocal<String> state = this.getAndCheckState(name);
        return new Trace(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return DefaultTracer.this.getAndCheckValue(name, state);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        this.traces.forEach((name, state) -> consumer.accept((String)name, this.getAndCheckValue((String)name, (ThreadLocal<String>)state)));
    }

    @Override
    public void stop() {
        this.traces.forEach((name, state) -> {
            String previous = this.getAndCheckValue((String)name, (ThreadLocal<String>)state);
            state.remove();
            this.listeners.onStop((String)name, previous);
        });
    }

    private ThreadLocal<String> getAndCheckState(String name) {
        ThreadLocal state = (ThreadLocal)this.traces.get((Object)name);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (String)"No such trace: %s", (Object[])new Object[]{name});
        return state;
    }

    private String getAndCheckValue(String name, ThreadLocal<String> state) {
        String value = state.get();
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"%s has not been started", (Object[])new Object[]{name});
        return value;
    }
}

