/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.zalando.tracer.Generator;
import org.zalando.tracer.Trace;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.Tracer;

final class StackedTracer
implements Tracer {
    private final ImmutableMap<String, ThreadLocal<Deque<String>>> traces;
    private final ImmutableMap<String, Generator> generators;
    private final TraceListener listeners;

    StackedTracer(ImmutableMap<String, Generator> generators, TraceListener listeners) {
        this.traces = Maps.toMap((Iterable)generators.keySet(), name -> ThreadLocal.withInitial(LinkedList::new));
        this.generators = generators;
        this.listeners = listeners;
    }

    @Override
    public void start(Function<String, String> provider) {
        this.traces.forEach((name, state) -> {
            Deque queue = (Deque)state.get();
            String previous = (String)queue.peekLast();
            String current = this.generate(provider, (String)name);
            queue.add(current);
            this.runIf(this.listeners::onStop, (String)name, previous);
            this.runIf(this.listeners::onStart, (String)name, current);
        });
    }

    private String generate(Function<String, String> provider, String name) {
        return Optional.ofNullable(provider.apply(name)).orElseGet(() -> ((Generator)this.generators.get((Object)name)).generate());
    }

    @Override
    public Trace get(final String name) {
        final ThreadLocal<Deque<String>> state = this.getAndCheckState(name);
        return new Trace(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return StackedTracer.this.getAndCheckValue(name, state);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        this.traces.forEach((name, state) -> consumer.accept((String)name, this.getAndCheckValue((String)name, (ThreadLocal<Deque<String>>)state)));
    }

    @Override
    public void stop() {
        this.traces.forEach((name, state) -> {
            Deque queue = (Deque)state.get();
            String previous = this.checkValue((String)name, (String)queue.removeLast());
            String current = (String)queue.peekLast();
            this.runIf(this.listeners::onStop, (String)name, previous);
            this.runIf(this.listeners::onStart, (String)name, current);
        });
    }

    private void runIf(BiConsumer<String, String> action, String name, @Nullable String current) {
        if (current != null) {
            action.accept(name, current);
        }
    }

    private ThreadLocal<Deque<String>> getAndCheckState(String name) {
        ThreadLocal state = (ThreadLocal)this.traces.get((Object)name);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (String)"No such trace: %s", (Object[])new Object[]{name});
        return state;
    }

    private String getAndCheckValue(String name, ThreadLocal<Deque<String>> state) {
        String value = state.get().peekLast();
        return this.checkValue(name, value);
    }

    private String checkValue(String name, @Nullable String value) {
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"%s has not been started", (Object[])new Object[]{name});
        return value;
    }
}

