/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.zalando.tracer.DefaultTracer;
import org.zalando.tracer.Generator;
import org.zalando.tracer.StackedTracer;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.TraceListeners;
import org.zalando.tracer.Tracer;
import org.zalando.tracer.UUIDGenerator;

public final class TracerFactory {
    TracerFactory() {
    }

    static Tracer create(boolean stacked, ImmutableList<String> traces, ImmutableMap<String, Generator> customs, ImmutableList<TraceListener> listeners) {
        UUIDGenerator defaultGenerator = new UUIDGenerator();
        ImmutableMap combined = ImmutableMap.builder().putAll(customs).putAll((Map)Maps.toMap(traces, trace -> defaultGenerator)).build();
        if (stacked) {
            return new StackedTracer((ImmutableMap<String, Generator>)combined, TraceListeners.compound(listeners));
        }
        return new DefaultTracer((ImmutableMap<String, Generator>)combined, TraceListeners.compound(listeners));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean stacked;
        private ImmutableList.Builder<String> traces;
        private ImmutableMap.Builder<String, Generator> customs;
        private ImmutableList.Builder<TraceListener> listeners;

        public Builder stacked(boolean stacked) {
            this.stacked = stacked;
            return this;
        }

        public Builder stacked() {
            this.stacked = true;
            return this;
        }

        Builder() {
        }

        public Builder trace(String trace) {
            if (this.traces == null) {
                this.traces = ImmutableList.builder();
            }
            this.traces.add((Object)trace);
            return this;
        }

        public Builder traces(Iterable<? extends String> traces) {
            if (this.traces == null) {
                this.traces = ImmutableList.builder();
            }
            this.traces.addAll(traces);
            return this;
        }

        public Builder clearTraces() {
            this.traces = null;
            return this;
        }

        public Builder trace(String key, Generator value) {
            if (this.customs == null) {
                this.customs = ImmutableMap.builder();
            }
            this.customs.put((Object)key, (Object)value);
            return this;
        }

        public Builder customs(Map<? extends String, ? extends Generator> customs) {
            if (this.customs == null) {
                this.customs = ImmutableMap.builder();
            }
            this.customs.putAll(customs);
            return this;
        }

        public Builder clearCustoms() {
            this.customs = null;
            return this;
        }

        public Builder listener(TraceListener listener) {
            if (this.listeners == null) {
                this.listeners = ImmutableList.builder();
            }
            this.listeners.add((Object)listener);
            return this;
        }

        public Builder listeners(Iterable<? extends TraceListener> listeners) {
            if (this.listeners == null) {
                this.listeners = ImmutableList.builder();
            }
            this.listeners.addAll(listeners);
            return this;
        }

        public Builder clearListeners() {
            this.listeners = null;
            return this;
        }

        public Tracer build() {
            ImmutableList traces = this.traces == null ? ImmutableList.of() : this.traces.build();
            ImmutableMap customs = this.customs == null ? ImmutableMap.of() : this.customs.build();
            ImmutableList listeners = this.listeners == null ? ImmutableList.of() : this.listeners.build();
            return TracerFactory.create(this.stacked, (ImmutableList<String>)traces, (ImmutableMap<String, Generator>)customs, (ImmutableList<TraceListener>)listeners);
        }

        public String toString() {
            return "TracerFactory.Builder(stacked=" + this.stacked + ", traces=" + this.traces + ", customs=" + this.customs + ", listeners=" + this.listeners + ")";
        }
    }
}

