/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.zalando.tracer.Trace;
import org.zalando.tracer.TracerFactory;

public interface Tracer {
    default public void start() {
        this.start(name -> null);
    }

    public void start(Function<String, String> var1);

    public boolean isActive();

    public Trace get(String var1);

    public void forEach(BiConsumer<String, String> var1);

    default public Map<String, String> snapshot() {
        LinkedHashMap map = new LinkedHashMap();
        this.forEach(map::put);
        return Collections.unmodifiableMap(map);
    }

    public void stop();

    default public Runnable manage(Runnable task) {
        return this.delegate(task, (String name) -> null);
    }

    default public Runnable preserve(Runnable task) {
        return this.delegate(task, this.snapshot()::get);
    }

    default public Runnable tryPreserve(Runnable task) {
        return this.isActive() ? this.preserve(task) : this.manage(task);
    }

    default public Runnable delegate(Runnable task, Function<String, String> provider) {
        return () -> {
            this.start(provider);
            try {
                task.run();
            }
            finally {
                this.stop();
            }
        };
    }

    default public <V> Callable<V> manage(Callable<V> task) {
        return this.delegate(task, (String name) -> null);
    }

    default public <V> Callable<V> preserve(Callable<V> task) {
        return this.delegate(task, this.snapshot()::get);
    }

    default public <V> Callable<V> tryPreserve(Callable<V> task) {
        return this.isActive() ? this.preserve(task) : this.manage(task);
    }

    default public <V> Callable<V> delegate(Callable<V> task, Function<String, String> provider) {
        return () -> {
            this.start(provider);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                this.stop();
            }
        };
    }

    public static Tracer create(String ... names) {
        return Tracer.builder().traces(Arrays.asList(names)).build();
    }

    public static TracerFactory.Builder builder() {
        return TracerFactory.builder();
    }
}

