/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.zalando.tracer.Generator;
import org.zalando.tracer.Trace;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.TraceListeners;
import org.zalando.tracer.Tracer;

final class DefaultTracer
implements Tracer {
    private final Map<String, ThreadLocal<String>> traces;
    private final Map<String, Generator> generators;
    private final TraceListener listeners;

    DefaultTracer(Map<String, Generator> generators, Collection<TraceListener> listeners) {
        this.traces = generators.keySet().stream().collect(Collectors.toMap(Function.identity(), name -> new ThreadLocal()));
        this.generators = generators;
        this.listeners = TraceListeners.compound(listeners);
    }

    @Override
    public void start(Function<String, String> provider) {
        this.traces.forEach((? super K name, ? super V state) -> {
            if (state.get() != null) {
                throw new IllegalStateException(name + " is already started");
            }
            String current = this.generate(provider, (String)name);
            state.set(current);
            this.listeners.onStart((String)name, current);
        });
    }

    @Override
    public boolean isActive() {
        return this.traces.values().stream().map(ThreadLocal::get).anyMatch(Objects::nonNull);
    }

    private String generate(Function<String, String> provider, String name) {
        return Optional.ofNullable(provider.apply(name)).orElseGet(() -> this.generators.get(name).generate());
    }

    @Override
    public Trace get(final String name) {
        final ThreadLocal<String> state = this.getAndCheckState(name);
        return new Trace(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return DefaultTracer.this.getAndCheckValue(name, state);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        this.traces.forEach((? super K name, ? super V state) -> consumer.accept((String)name, this.getAndCheckValue((String)name, (ThreadLocal<String>)state)));
    }

    @Override
    public void stop() {
        this.traces.forEach((? super K name, ? super V state) -> {
            String previous = this.getAndCheckValue((String)name, (ThreadLocal<String>)state);
            state.remove();
            this.listeners.onStop((String)name, previous);
        });
    }

    private ThreadLocal<String> getAndCheckState(String name) {
        ThreadLocal<String> state = this.traces.get(name);
        if (state == null) {
            throw new IllegalArgumentException("No such trace: " + name);
        }
        return state;
    }

    private String getAndCheckValue(String name, ThreadLocal<String> state) {
        String value = state.get();
        if (value == null) {
            throw new IllegalStateException(name + " has not been started");
        }
        return value;
    }
}

