/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import java.security.SecureRandom;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.zalando.tracer.Generator;

@API(status=API.Status.STABLE)
public final class PhraseGenerator
implements Generator {
    private static final String[] ADJECTIVES = new String[]{"admiring", "adoring", "agitated", "amazing", "angry", "awesome", "backstabbing", "berserk", "big", "boring", "clever", "cocky", "compassionate", "condescending", "cranky", "desperate", "determined", "distracted", "dreamy", "drunk", "ecstatic", "elated", "elegant", "evil", "fervent", "focused", "furious", "gigantic", "gloomy", "goofy", "grave", "happy", "high", "hopeful", "hungry", "infallible", "jolly", "jovial", "kickass", "lonely", "loving", "mad", "modest", "naughty", "nauseous", "nostalgic", "peaceful", "pedantic", "pensive", "prickly", "reverent", "romantic", "sad", "serene", "sharp", "sick", "silly", "sleepy", "small", "stoic", "stupefied", "suspicious", "tender", "thirsty", "tiny", "trusting", "zen"};
    private static final String[] SURNAMES = new String[]{"albattani", "allen", "almeida", "agnesi", "archimedes", "ardinghelli", "aryabhata", "austin", "babbage", "banach", "bardeen", "bartik", "bassi", "bell", "bhabha", "bhaskara", "blackwell", "bohr", "booth", "borg", "bose", "boyd", "brahmagupta", "brattain", "brown", "carson", "chandrasekhar", "shannon", "colden", "cori", "cray", "curran", "curie", "darwin", "davinci", "dijkstra", "dubinsky", "easley", "einstein", "elion", "engelbart", "euclid", "euler", "fermat", "fermi", "feynman", "franklin", "galileo", "gates", "goldberg", "goldstine", "goldwasser", "golick", "goodall", "hamilton", "hawking", "heisenberg", "heyrovsky", "hodgkin", "hoover", "hopper", "hugle", "hypatia", "jang", "jennings", "jepsen", "joliot", "jones", "kalam", "kare", "keller", "khorana", "kilby", "kirch", "knuth", "kowalevski", "lalande", "lamarr", "lamport", "leakey", "leavitt", "lichterman", "liskov", "lovelace", "lumiere", "mahavira", "mayer", "mccarthy", "mcclintock", "mclean", "mcnulty", "meitner", "meninsky", "mestorf", "minsky", "mirzakhani", "morse", "murdock", "newton", "nobel", "noether", "northcutt", "noyce", "panini", "pare", "pasteur", "payne", "perlman", "pike", "poincare", "poitras", "ptolemy", "raman", "ramanujan", "ride", "montalcini", "ritchie", "roentgen", "rosalind", "saha", "sammet", "shaw", "shirley", "shockley", "sinoussi", "snyder", "spence", "stallman", "stonebraker", "swanson", "swartz", "swirles", "tesla", "thompson", "torvalds", "turing", "varahamihira", "visvesvaraya", "volhard", "wescoff", "williams", "wilson", "wing", "wozniak", "wright", "yalow", "yonath"};
    private static final String[] VERBS = new String[]{"asks", "pays", "sees", "waits", "calls", "feeds", "helps", "knows", "likes", "meets", "saves", "tells"};
    private static final String[][] PARTS = new String[][]{ADJECTIVES, SURNAMES, VERBS, ADJECTIVES, SURNAMES};

    @Override
    public String generate() {
        return PhraseGenerator.generate(Holder.RANDOM::nextInt);
    }

    static String generate(IntUnaryOperator r) {
        String name;
        while ((name = Stream.of(PARTS).map(dict -> dict[r.applyAsInt(((String[])dict).length)]).collect(Collectors.joining("_"))).contains("boring_wozniak")) {
        }
        return name;
    }

    static long maxCombinations() {
        return Stream.of(PARTS).mapToLong(dict -> ((String[])dict).length).reduce(1L, (a, b) -> a * b);
    }

    static int minLength() {
        return Stream.of(PARTS).mapToInt(dict -> Stream.of(dict).mapToInt(String::length).min().orElse(0)).sum() + (PARTS.length - 1);
    }

    static int maxLength() {
        return Stream.of(PARTS).mapToInt(dict -> Stream.of(dict).mapToInt(String::length).max().orElse(0)).sum() + (PARTS.length - 1);
    }

    static class Holder {
        static final SecureRandom RANDOM = new SecureRandom();

        private Holder() {
        }
    }
}

