/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.zalando.tracer.DefaultTracer;
import org.zalando.tracer.Generator;
import org.zalando.tracer.StackedTracer;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.Tracer;
import org.zalando.tracer.UUIDGenerator;

@API(status=API.Status.STABLE)
public final class TracerFactory {
    private TracerFactory() {
    }

    static Tracer create(boolean stacked, List<String> traces, Map<String, Generator> customs, List<TraceListener> listeners) {
        UUIDGenerator defaultGenerator = new UUIDGenerator();
        LinkedHashMap<String, Generator> combined = new LinkedHashMap<String, Generator>();
        combined.putAll(customs);
        combined.putAll(traces.stream().collect(Collectors.toMap(Function.identity(), trace -> defaultGenerator)));
        if (stacked) {
            return new StackedTracer(combined, listeners);
        }
        return new DefaultTracer(combined, listeners);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean stacked;
        private ArrayList<String> traces;
        private ArrayList<String> customs$key;
        private ArrayList<Generator> customs$value;
        private ArrayList<TraceListener> listeners;

        public Builder stacked(boolean stacked) {
            this.stacked = stacked;
            return this;
        }

        public Builder stacked() {
            this.stacked = true;
            return this;
        }

        Builder() {
        }

        public Builder trace(String trace) {
            if (this.traces == null) {
                this.traces = new ArrayList();
            }
            this.traces.add(trace);
            return this;
        }

        public Builder traces(Collection<? extends String> traces) {
            if (this.traces == null) {
                this.traces = new ArrayList();
            }
            this.traces.addAll(traces);
            return this;
        }

        public Builder clearTraces() {
            if (this.traces != null) {
                this.traces.clear();
            }
            return this;
        }

        public Builder trace(String traceKey, Generator traceValue) {
            if (this.customs$key == null) {
                this.customs$key = new ArrayList();
                this.customs$value = new ArrayList();
            }
            this.customs$key.add(traceKey);
            this.customs$value.add(traceValue);
            return this;
        }

        public Builder customs(Map<? extends String, ? extends Generator> customs) {
            if (this.customs$key == null) {
                this.customs$key = new ArrayList();
                this.customs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Generator> $lombokEntry : customs.entrySet()) {
                this.customs$key.add($lombokEntry.getKey());
                this.customs$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public Builder clearCustoms() {
            if (this.customs$key != null) {
                this.customs$key.clear();
                this.customs$value.clear();
            }
            return this;
        }

        public Builder listener(TraceListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
            return this;
        }

        public Builder listeners(Collection<? extends TraceListener> listeners) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.addAll(listeners);
            return this;
        }

        public Builder clearListeners() {
            if (this.listeners != null) {
                this.listeners.clear();
            }
            return this;
        }

        public Tracer build() {
            List<TraceListener> listeners;
            Map<String, Generator> customs;
            List<String> traces;
            switch (this.traces == null ? 0 : this.traces.size()) {
                case 0: {
                    traces = Collections.emptyList();
                    break;
                }
                case 1: {
                    traces = Collections.singletonList(this.traces.get(0));
                    break;
                }
                default: {
                    traces = Collections.unmodifiableList(new ArrayList<String>(this.traces));
                }
            }
            switch (this.customs$key == null ? 0 : this.customs$key.size()) {
                case 0: {
                    customs = Collections.emptyMap();
                    break;
                }
                case 1: {
                    customs = Collections.singletonMap(this.customs$key.get(0), this.customs$value.get(0));
                    break;
                }
                default: {
                    customs = new LinkedHashMap(this.customs$key.size() < 0x40000000 ? 1 + this.customs$key.size() + (this.customs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.customs$key.size(); ++$i) {
                        customs.put(this.customs$key.get($i), this.customs$value.get($i));
                    }
                    customs = Collections.unmodifiableMap(customs);
                }
            }
            switch (this.listeners == null ? 0 : this.listeners.size()) {
                case 0: {
                    listeners = Collections.emptyList();
                    break;
                }
                case 1: {
                    listeners = Collections.singletonList(this.listeners.get(0));
                    break;
                }
                default: {
                    listeners = Collections.unmodifiableList(new ArrayList<TraceListener>(this.listeners));
                }
            }
            return TracerFactory.create(this.stacked, traces, customs, listeners);
        }

        public String toString() {
            return "TracerFactory.Builder(stacked=" + this.stacked + ", traces=" + this.traces + ", customs$key=" + this.customs$key + ", customs$value=" + this.customs$value + ", listeners=" + this.listeners + ")";
        }
    }
}

