/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.Tracer;

public final class LoggingTraceListener
implements TraceListener {
    private final Logger logger;

    public LoggingTraceListener() {
        this(LoggerFactory.getLogger(Tracer.class));
    }

    public LoggingTraceListener(Logger logger) {
        this.logger = logger;
    }

    @VisibleForTesting
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void onStart(String name, String value) {
        this.logger.trace("Started [{}] trace: [{}]", (Object)name, (Object)value);
    }

    @Override
    public void onStop(String name, String value) {
        this.logger.trace("Stopped [{}] trace: [{}]", (Object)name, (Object)value);
    }
}

