/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.zalando.tracer.DefaultTracer;
import org.zalando.tracer.Generator;
import org.zalando.tracer.Trace;
import org.zalando.tracer.TraceListener;
import org.zalando.tracer.UUIDGenerator;

public interface Tracer {
    default public void start() {
        this.start(name -> null);
    }

    public void start(Function<String, String> var1);

    public Trace get(String var1);

    public void forEach(BiConsumer<String, String> var1);

    default public ImmutableMap<String, String> snapshot() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    public void stop();

    default public Runnable manage(Runnable task) {
        return this.delegate(task, (String name) -> null);
    }

    default public Runnable preserve(Runnable task) {
        return this.delegate(task, arg_0 -> this.snapshot().get(arg_0));
    }

    default public Runnable delegate(Runnable task, Function<String, String> provider) {
        return () -> {
            this.start(provider);
            try {
                task.run();
            }
            finally {
                this.stop();
            }
        };
    }

    default public <V> Callable<V> manage(Callable<V> task) {
        return this.delegate(task, (String name) -> null);
    }

    default public <V> Callable<V> preserve(Callable<V> task) {
        return this.delegate(task, arg_0 -> this.snapshot().get(arg_0));
    }

    default public <V> Callable<V> delegate(Callable<V> task, Function<String, String> provider) {
        return () -> {
            this.start(provider);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                this.stop();
            }
        };
    }

    public static Tracer create(String ... names) {
        return Tracer.builder().traces(Arrays.asList(names)).build();
    }

    public static Tracer create(ImmutableList<String> traces, ImmutableMap<String, Generator> customs, ImmutableList<TraceListener> listeners) {
        UUIDGenerator defaultGenerator = new UUIDGenerator();
        ImmutableMap combined = ImmutableMap.builder().putAll(customs).putAll((Map)Maps.toMap(traces, trace -> defaultGenerator)).build();
        return new DefaultTracer((ImmutableMap<String, Generator>)combined, listeners);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList.Builder<String> traces;
        private ImmutableMap.Builder<String, Generator> customs;
        private ImmutableList.Builder<TraceListener> listeners;

        Builder() {
        }

        public Builder trace(String trace) {
            if (this.traces == null) {
                this.traces = ImmutableList.builder();
            }
            this.traces.add((Object)trace);
            return this;
        }

        public Builder traces(Iterable<? extends String> traces) {
            if (this.traces == null) {
                this.traces = ImmutableList.builder();
            }
            this.traces.addAll(traces);
            return this;
        }

        public Builder trace(String trace$key, Generator trace$value) {
            if (this.customs == null) {
                this.customs = ImmutableMap.builder();
            }
            this.customs.put((Object)trace$key, (Object)trace$value);
            return this;
        }

        public Builder customs(Map<? extends String, ? extends Generator> customs) {
            if (this.customs == null) {
                this.customs = ImmutableMap.builder();
            }
            this.customs.putAll(customs);
            return this;
        }

        public Builder listener(TraceListener listener) {
            if (this.listeners == null) {
                this.listeners = ImmutableList.builder();
            }
            this.listeners.add((Object)listener);
            return this;
        }

        public Builder listeners(Iterable<? extends TraceListener> listeners) {
            if (this.listeners == null) {
                this.listeners = ImmutableList.builder();
            }
            this.listeners.addAll(listeners);
            return this;
        }

        public Tracer build() {
            ImmutableList traces = this.traces == null ? ImmutableList.of() : this.traces.build();
            ImmutableMap customs = this.customs == null ? ImmutableMap.of() : this.customs.build();
            ImmutableList listeners = this.listeners == null ? ImmutableList.of() : this.listeners.build();
            return Tracer.create((ImmutableList<String>)traces, (ImmutableMap<String, Generator>)customs, (ImmutableList<TraceListener>)listeners);
        }

        public String toString() {
            return "Tracer.Builder(traces=" + this.traces + ", customs=" + this.customs + ", listeners=" + this.listeners + ")";
        }
    }
}

