/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.tracer.servlet;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;
import org.zalando.tracer.Tracer;
import org.zalando.tracer.servlet.HttpFilter;

@API(status=API.Status.STABLE)
public final class TracerFilter
implements HttpFilter {
    private final Tracer tracer;

    public TracerFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.requiresTraceManagement(request.getDispatcherType())) {
            Function<String, String> provider = this.selectProvider(request);
            this.tracer.start(provider);
            try {
                this.persistTraces(request, response);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                this.tracer.stop();
            }
        } else {
            this.persistTraces(request, response);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean requiresTraceManagement(DispatcherType dispatcherType) {
        switch (dispatcherType) {
            case FORWARD: 
            case INCLUDE: {
                return false;
            }
        }
        return true;
    }

    private Function<String, String> selectProvider(HttpServletRequest request) {
        DispatcherType dispatcherType = request.getDispatcherType();
        switch (dispatcherType) {
            case FORWARD: 
            case INCLUDE: 
            case ASYNC: 
            case ERROR: {
                Function<Object, String> toString = Objects::toString;
                Function<String, Object> getAttribute = arg_0 -> ((HttpServletRequest)request).getAttribute(arg_0);
                return getAttribute.andThen(toString);
            }
        }
        return arg_0 -> ((HttpServletRequest)request).getHeader(arg_0);
    }

    private void persistTraces(HttpServletRequest request, HttpServletResponse response) {
        BiConsumer<String, String> setAttribute = (arg_0, arg_1) -> ((HttpServletRequest)request).setAttribute(arg_0, arg_1);
        BiConsumer<String, String> setHeader = (arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1);
        this.tracer.forEach(setAttribute.andThen(setHeader));
    }
}

