/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.twintip.spring;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.Yaml;
import org.zalando.twintip.spring.SchemaDiscovery;

@RestController
public class SchemaResource {
    public static final String SCHEMA_DISCOVERY_MAPPING = "/.well-known/schema-discovery";
    private final Yaml yaml = new Yaml();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String apiYamlValue;
    private final String apiJsonValue;

    @Autowired
    public SchemaResource(@Value(value="${twintip.yaml}") Resource yamlResource) throws IOException {
        this.apiYamlValue = SchemaResource.consume(yamlResource.getInputStream());
        this.apiJsonValue = this.yamlToJson(this.apiYamlValue);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/.well-known/schema-discovery"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public SchemaDiscovery discover(@Value(value="${twintip.mapping}") String mapping, @Value(value="${twintip.type:swagger-2.0}") String type, @Value(value="${twintip.ui:}") String uiPath) {
        return new SchemaDiscovery(mapping, type, uiPath.isEmpty() ? Optional.empty() : Optional.of(uiPath));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"${twintip.mapping}"}, produces={"application/json", "*/*"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> schemaAsJson() {
        return this.response(this.apiJsonValue);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"${twintip.mapping}"}, produces={"application/yaml", "application/x-yaml", "text/yaml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseEntity<String> schemaAsYaml() {
        return this.response(this.apiYamlValue);
    }

    private ResponseEntity<String> response(String body) {
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Access-Control-Allow-Origin", new String[]{"*"})).header("Access-Control-Allow-Methods", new String[]{"GET"})).header("Access-Control-Max-Age", new String[]{"3600"})).header("Access-Control-Allow-Headers", new String[]{""})).body((Object)body);
    }

    private String yamlToJson(String yamlValue) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(this.yaml.load(yamlValue));
    }

    public static String consume(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }
}

