/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.twintip.spring;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.zalando.twintip.spring.SchemaDiscovery;

@RestController
public class SchemaResource {
    public static final String SCHEMA_DISCOVERY_MAPPING = "/.well-known/schema-discovery";
    private final ObjectMapper json = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final ObjectMapper yaml = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final Map<String, Object> node;
    private final boolean enableCors;

    @Autowired
    public SchemaResource(@Value(value="${twintip.yaml}") Resource yamlResource, @Value(value="${twintip.cors:true}") boolean enableCors, @Value(value="${twintip.baseUrl:}") String baseUrl) throws IOException {
        this.node = (Map)this.yaml.readValue(yamlResource.getInputStream(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.enableCors = enableCors;
        if (!StringUtils.isEmpty((Object)baseUrl)) {
            this.updateApiUrl(this.node, URI.create(baseUrl));
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/.well-known/schema-discovery"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public SchemaDiscovery discover(@Value(value="${twintip.mapping}") String mapping, @Value(value="${twintip.type:swagger-2.0}") String type, @Value(value="${twintip.ui:}") String uiPath) {
        return new SchemaDiscovery(mapping, type, uiPath);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"${twintip.mapping}"}, produces={"application/json", "*/*"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> jsonSchema() throws JsonProcessingException {
        return this.response(this.json.writeValueAsString(this.node));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"${twintip.mapping}"}, produces={"application/yaml", "application/x-yaml", "text/yaml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseEntity<String> yamlSchema() throws JsonProcessingException {
        return this.response(this.yaml.writeValueAsString(this.node));
    }

    private ResponseEntity<String> response(String body) {
        ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
        if (this.enableCors) {
            ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)builder.header("Access-Control-Allow-Origin", new String[]{"*"})).header("Access-Control-Allow-Methods", new String[]{"GET"})).header("Access-Control-Max-Age", new String[]{"3600"})).header("Access-Control-Allow-Headers", new String[]{""});
        }
        return builder.body((Object)body);
    }

    private void updateApiUrl(Map<String, Object> apiDef, URI baseUrl) {
        apiDef.put("host", Objects.requireNonNull(baseUrl.getHost(), "baseUrl must contain host") + (String)(baseUrl.getPort() != -1 ? ":" + baseUrl.getPort() : ""));
        apiDef.put("schemes", new String[]{Objects.requireNonNull(baseUrl.getScheme(), "baseUrl must contain scheme")});
        apiDef.put("basePath", Objects.requireNonNull(baseUrl.getPath(), "baseUrl must contain path"));
    }
}

