/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.binding;

import io.swagger.models.Swagger;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.axiom.web.SwaggerRouter;
import org.zalando.axiom.web.binding.DefaultBindingBuilder;
import org.zalando.axiom.web.binding.RouteConfiguration;
import org.zalando.axiom.web.binding.SwaggerVertxRouter;
import org.zalando.axiom.web.binding.functions.AsyncIntFunction;
import org.zalando.axiom.web.binding.functions.AsyncStringFunction;
import org.zalando.axiom.web.binding.functions.AsyncSupplier;
import org.zalando.axiom.web.binding.functions.StringFunction;
import org.zalando.axiom.web.util.Preconditions;
import org.zalando.axiom.web.util.Strings;

public class BindingBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BindingBuilderFactory.class);
    private final SwaggerRouter swaggerRouter;
    private final Map<String, RouteConfiguration> routeConfigurations;

    public BindingBuilderFactory(SwaggerRouter swaggerRouter) {
        this.swaggerRouter = swaggerRouter;
        this.routeConfigurations = new HashMap<String, RouteConfiguration>();
    }

    public DefaultBindingBuilder bindTo(String path) {
        Preconditions.checkNotNull(path, "Path must not be null!");
        this.checkPathBinding(path);
        return new DefaultBindingBuilder(this, this.swaggerRouter, path);
    }

    public BindingBuilderFactory get(String path, Supplier<Object> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public <T> BindingBuilderFactory get(String path, AsyncSupplier<T> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public <T, R> BindingBuilderFactory get(String path, Class<T> paramType, Function<T, R> function) {
        this.getBindingBuilder(path).get(paramType, function).doBind();
        return this;
    }

    public BindingBuilderFactory get(String path, StringFunction<Object> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public BindingBuilderFactory get(String path, AsyncStringFunction<Object> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public BindingBuilderFactory get(String path, AsyncIntFunction<Object> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public <T> BindingBuilderFactory getById(String path, StringFunction<T> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public <T> BindingBuilderFactory getById(String path, AsyncStringFunction<T> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public <T> BindingBuilderFactory getById(String path, AsyncIntFunction<T> supplier) {
        this.getBindingBuilder(path).get(supplier).doBind();
        return this;
    }

    public Router router(Vertx vertx) {
        SwaggerVertxRouter router = SwaggerVertxRouter.router(vertx);
        for (RouteConfiguration routeConfiguration : this.routeConfigurations.values()) {
            for (Map.Entry<HttpMethod, List<Handler<RoutingContext>>> entry : routeConfiguration.entrySet()) {
                Swagger swagger = this.swaggerRouter.getSwagger();
                String basePath = Strings.valueOrElse(swagger.getBasePath(), "");
                String path = basePath + routeConfiguration.getVertxPath();
                LOGGER.debug(String.format("Binding method [%s] and path [%s].", entry.getKey(), path));
                entry.getValue().forEach(handler -> router.route((HttpMethod)entry.getKey(), path).handler(handler));
            }
        }
        return router;
    }

    private DefaultBindingBuilder getBindingBuilder(String path) {
        Preconditions.checkNotNull(path, "Path must not be null!");
        this.checkPathBinding(path);
        return new DefaultBindingBuilder(this, this.swaggerRouter, path);
    }

    void checkPathBinding(String path) {
        if (this.routeConfigurations.containsKey(path)) {
            throw new IllegalStateException(String.format("Configuration for route [%s] is already added!", path));
        }
    }

    void registerRoute(RouteConfiguration routeConfiguration) {
        this.routeConfigurations.put(routeConfiguration.getSwaggerPath(), routeConfiguration);
    }
}

