/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.binding;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.axiom.web.SwaggerRouter;
import org.zalando.axiom.web.binding.BindingBuilder;
import org.zalando.axiom.web.binding.BindingBuilderFactory;
import org.zalando.axiom.web.binding.RouteConfiguration;
import org.zalando.axiom.web.binding.functions.Async;
import org.zalando.axiom.web.binding.functions.AsyncFunction;
import org.zalando.axiom.web.binding.functions.AsyncIntFunction;
import org.zalando.axiom.web.binding.functions.AsyncStringConsumer;
import org.zalando.axiom.web.binding.functions.AsyncStringFunction;
import org.zalando.axiom.web.binding.functions.AsyncSupplier;
import org.zalando.axiom.web.handler.DeleteHandler;
import org.zalando.axiom.web.handler.GetHandler;
import org.zalando.axiom.web.handler.GetWithZeroOrOneParameterHandler;
import org.zalando.axiom.web.handler.MetricsHandler;
import org.zalando.axiom.web.handler.ParameterCheckHandler;
import org.zalando.axiom.web.handler.PostHandler;
import org.zalando.axiom.web.util.Preconditions;

public class DefaultBindingBuilder
implements BindingBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBindingBuilder.class);
    private final BindingBuilderFactory bindingBuilderFactory;
    private final SwaggerRouter swaggerRouter;
    private final RouteConfiguration routeConfiguration;
    private final Map<io.swagger.models.HttpMethod, Operation> operationMap;

    public DefaultBindingBuilder(BindingBuilderFactory bindingBuilderFactory, SwaggerRouter swaggerRouter, String path) {
        this.bindingBuilderFactory = bindingBuilderFactory;
        this.swaggerRouter = swaggerRouter;
        this.routeConfiguration = new RouteConfiguration(path);
        Path swaggerPath = swaggerRouter.getSwagger().getPath(this.routeConfiguration.getSwaggerPath());
        Preconditions.checkNotNull(swaggerPath, String.format("Could not find swagger path: [%s] in swagger spec: [%s]", this.routeConfiguration.getSwaggerPath(), swaggerRouter.getSwagger().getPaths().keySet()));
        this.operationMap = swaggerPath.getOperationMap();
    }

    public <T> DefaultBindingBuilder get(AsyncStringFunction<T> function) {
        this.get((Async)function);
        return this;
    }

    public <T> DefaultBindingBuilder get(AsyncIntFunction<T> function) {
        this.get((Async)function);
        return this;
    }

    public <T> DefaultBindingBuilder get(AsyncSupplier<T> function) {
        this.get((Async)function);
        return this;
    }

    public <T, R> DefaultBindingBuilder get(Class<T> paramType, AsyncFunction<T, R> function) {
        this.routeConfiguration.addHandler(HttpMethod.GET, new ParameterCheckHandler(this.operationMap.get(io.swagger.models.HttpMethod.GET)));
        this.routeConfiguration.addHandler(HttpMethod.GET, this.toMetricsHandler(new GetHandler<T>(this.swaggerRouter.getMapper(), function, paramType, this.swaggerRouter.getSwagger().getPath(this.routeConfiguration.getSwaggerPath()))));
        return this;
    }

    public <T> DefaultBindingBuilder getMetrics(Function<MetricRegistry, T> function) {
        this.routeConfiguration.addHandler(HttpMethod.GET, (Handler<RoutingContext>)((Handler)routingContext -> {
            try {
                routingContext.response().end(this.swaggerRouter.getMapper().writeValueAsString(function.apply(this.swaggerRouter.getMetricsRegistry())));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error on de-serializing metrics!", (Throwable)e);
                routingContext.response().setStatusCode(500).end();
            }
        }));
        return this;
    }

    private DefaultBindingBuilder get(Async function) {
        this.routeConfiguration.addHandler(HttpMethod.GET, new ParameterCheckHandler(this.operationMap.get(io.swagger.models.HttpMethod.GET)));
        this.routeConfiguration.addHandler(HttpMethod.GET, this.toMetricsHandler(new GetWithZeroOrOneParameterHandler(this.swaggerRouter.getMapper(), function)));
        return this;
    }

    public <T, R> DefaultBindingBuilder post(Class<T> paramType, AsyncFunction<T, R> function) {
        Operation postOperation = this.getPostOperation();
        this.routeConfiguration.addHandler(HttpMethod.POST, this.toMetricsHandler(new PostHandler<T>(postOperation, this.swaggerRouter.getMapper(), function, paramType)));
        return this;
    }

    public DefaultBindingBuilder delete(AsyncStringConsumer function) {
        this.routeConfiguration.addHandler(HttpMethod.DELETE, this.toMetricsHandler(new DeleteHandler(this.getDeleteOperation(), function)));
        return this;
    }

    @Override
    public BindingBuilderFactory doBind() {
        this.bindingBuilderFactory.registerRoute(this.routeConfiguration);
        return this.bindingBuilderFactory;
    }

    private Handler<RoutingContext> toMetricsHandler(Handler<RoutingContext> handler) {
        if (this.swaggerRouter.isMetricsEnabled()) {
            return new MetricsHandler(this.swaggerRouter.getMetricsRegistry(), handler, this.routeConfiguration.getVertxPath());
        }
        return handler;
    }

    private Operation getGetOperation() {
        return this.swaggerRouter.getSwagger().getPath(this.routeConfiguration.getSwaggerPath()).getGet();
    }

    private Operation getPostOperation() {
        return this.swaggerRouter.getSwagger().getPath(this.routeConfiguration.getSwaggerPath()).getPost();
    }

    private Operation getDeleteOperation() {
        return this.swaggerRouter.getSwagger().getPath(this.routeConfiguration.getSwaggerPath()).getDelete();
    }
}

