/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.binding;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zalando.axiom.web.util.Preconditions;
import org.zalando.axiom.web.util.Strings;
import org.zalando.axiom.web.util.Util;

class RouteConfiguration {
    private final String vertxPath;
    private final String swaggerPath;
    private final Map<HttpMethod, List<Handler<RoutingContext>>> httpMethodToHandler;

    RouteConfiguration(String path) {
        Preconditions.checkNotNull(path, "Path must not be null!");
        this.vertxPath = Strings.toVertxPathParams(path);
        this.swaggerPath = Strings.toSwaggerPathParams(path);
        this.httpMethodToHandler = new HashMap<HttpMethod, List<Handler<RoutingContext>>>();
    }

    void addHandler(HttpMethod httpMethod, Handler<RoutingContext> handler) {
        Util.getOrPut(this.httpMethodToHandler, httpMethod, LinkedList::new).add(handler);
    }

    String getVertxPath() {
        return this.vertxPath;
    }

    public String getSwaggerPath() {
        return this.swaggerPath;
    }

    Set<Map.Entry<HttpMethod, List<Handler<RoutingContext>>>> entrySet() {
        return this.httpMethodToHandler.entrySet();
    }
}

