/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultRouteHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRouteHandler.class);

    protected <T> AsyncResultHandler defaultAsyncResultHandler(final RoutingContext routingContext, final Consumer<T> callback) {
        return new AsyncResultHandler<T>(){

            public void handle(AsyncResult<T> event) {
                if (event.succeeded()) {
                    callback.accept(event.result());
                } else {
                    DefaultRouteHandler.this.handleControllerError(routingContext, event.cause());
                }
            }
        };
    }

    protected void handleControllerError(RoutingContext routingContext, Throwable cause) {
        String path = routingContext.currentRoute() != null ? routingContext.currentRoute().getPath() : null;
        this.handleError(String.format("Invoking controller method failed: [%s]", path), cause, routingContext);
    }

    protected void handleError(String message, Throwable cause, RoutingContext routingContext) {
        LOGGER.error(message, cause);
        routingContext.fail(500);
    }
}

