/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.handler;

import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.HashSet;
import java.util.Map;
import org.zalando.axiom.web.binding.functions.AsyncStringConsumer;
import org.zalando.axiom.web.util.HandlerUtils;

public class DeleteHandler
implements Handler<RoutingContext> {
    private final AsyncStringConsumer function;
    private static final HashSet<String> ACCEPTED_RESPONSE_CODES = new HashSet();

    public DeleteHandler(Operation operation, AsyncStringConsumer function) {
        this.function = function;
        this.checkResponses(operation.getResponses());
    }

    private void checkResponses(Map<String, Response> responses) {
        if (!responses.keySet().containsAll(ACCEPTED_RESPONSE_CODES)) {
            throw new IllegalStateException("Swagger definition must contain status codes 204 and 500 in response definition!");
        }
    }

    public void handle(RoutingContext routingContext) {
        String id = HandlerUtils.getOnlyValue(routingContext);
        try {
            this.function.accept(id, (AsyncResultHandler<Void>)((AsyncResultHandler)asyncResult -> {
                if (asyncResult.succeeded()) {
                    routingContext.response().setStatusCode(204).end();
                } else {
                    routingContext.fail(500);
                }
            }));
        }
        catch (Exception e) {
            routingContext.fail(500);
        }
    }

    static {
        ACCEPTED_RESPONSE_CODES.add("204");
        ACCEPTED_RESPONSE_CODES.add("500");
    }
}

