/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.parameters.AbstractParameter;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.zalando.axiom.web.binding.functions.AsyncFunction;
import org.zalando.axiom.web.handler.DefaultRouteHandler;
import org.zalando.axiom.web.util.Preconditions;
import org.zalando.axiom.web.util.Strings;
import org.zalando.axiom.web.util.Types;

public class GetHandler<T>
extends DefaultRouteHandler {
    private final ObjectMapper mapper;
    private final Object function;
    private final Class<T> paramType;
    private final Path path;

    public GetHandler(ObjectMapper mapper, Object function, Class<T> paramType, Path path) {
        Preconditions.checkNotNull(mapper, "Mapper must not be null!");
        Preconditions.checkNotNull(function, "Function must not be null!");
        Preconditions.checkNotNull(paramType, "ParamType must not be null!");
        Preconditions.checkNotNull(path, "Path must not be null!");
        this.mapper = mapper;
        this.function = function;
        this.paramType = paramType;
        this.path = path;
    }

    public void handle(RoutingContext routingContext) {
        MultiMap params = routingContext.request().params();
        try {
            Object parameter = this.hasDefaultConstructor(this.paramType) ? this.fillParameterWithDefaultConstructor(routingContext, this.paramType, params) : this.fillParameterWithNonDefaultConstructor(this.paramType, params);
            ((AsyncFunction)this.function).apply(parameter, this.defaultAsyncResultHandler(routingContext, result -> {
                try {
                    if (result == null) {
                        routingContext.response().setStatusCode(404).end();
                    } else {
                        routingContext.response().setStatusCode(200).end(this.mapper.writeValueAsString(result));
                    }
                }
                catch (JsonProcessingException e) {
                    this.handleError(String.format("Could not serialize result [%s]!", result.getClass().getName()), e, routingContext);
                }
            }));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.handleControllerError(routingContext, e);
        }
    }

    private Object fillParameterWithNonDefaultConstructor(Class<T> paramType, MultiMap params) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = this.getConstructorWithParameterCount(params.names().size(), paramType);
        LinkedList<Object> constructorValues = new LinkedList<Object>();
        Map<String, Parameter> parameters = this.getParameterMap(this.path);
        for (Field field : paramType.getDeclaredFields()) {
            String name = field.getName();
            Class<?> type = this.getType(name, parameters.get(name));
            constructorValues.add(Types.castValueToType(this.getSingleValue(name, params), type));
        }
        return constructor.newInstance(constructorValues.toArray());
    }

    private Constructor<?> getConstructorWithParameterCount(int size, Class<T> paramType) {
        for (Constructor<?> constructor : paramType.getConstructors()) {
            if (constructor.getParameters().length != size) continue;
            return constructor;
        }
        throw new IllegalStateException(String.format("Could not find constructor with [%d] arguments for parameter object [%s]!", size, paramType.getName()));
    }

    private Object fillParameterWithDefaultConstructor(RoutingContext routingContext, Class<T> paramType, MultiMap params) throws InstantiationException, IllegalAccessException {
        T parameter = paramType.newInstance();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Map<String, Parameter> parameters = this.getParameterMap(this.path);
        for (String name : params.names()) {
            try {
                Class<?> type = this.getType(name, parameters.get(name));
                MethodHandle setter = lookup.findVirtual(paramType, Strings.getSetterName(name), MethodType.methodType(Void.TYPE, type));
                setter.invokeWithArguments(parameter, Types.castValueToType(this.getSingleValue(name, params), type));
            }
            catch (NoSuchFieldException e) {
                this.handleError(String.format("Could not find setter for field [%s]", name), e, routingContext);
            }
            catch (Throwable throwable) {
                this.handleError(String.format("Could not invoke setter for field [%s]!", name), throwable, routingContext);
            }
        }
        return parameter;
    }

    private Map<String, Parameter> getParameterMap(Path path) {
        Map operationMap = path.getOperationMap();
        return ((Operation)operationMap.get(HttpMethod.GET)).getParameters().stream().collect(Collectors.toMap(Parameter::getName, param -> param));
    }

    private boolean hasDefaultConstructor(Class<T> paramType) {
        for (Constructor<?> constructor : paramType.getConstructors()) {
            if (constructor.getParameters().length != 0) continue;
            return true;
        }
        return false;
    }

    private String getSingleValue(String name, MultiMap params) {
        return params.get(name);
    }

    private Class<?> getType(String name, Parameter parameter) {
        Preconditions.checkNotNull(parameter, String.format("Could not find parameter [%s] in swagger model!", name));
        if (parameter instanceof AbstractParameter) {
            AbstractSerializableParameter castedParam = (AbstractSerializableParameter)parameter;
            return Types.getParameterType(castedParam.getType(), castedParam.getFormat());
        }
        throw new UnsupportedOperationException(String.format("Parameter type [%s] not supported!", parameter.getClass().getName()));
    }
}

