/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.AsyncResultHandler;
import io.vertx.ext.web.RoutingContext;
import org.zalando.axiom.web.binding.functions.AsyncIntFunction;
import org.zalando.axiom.web.binding.functions.AsyncStringFunction;
import org.zalando.axiom.web.binding.functions.AsyncSupplier;
import org.zalando.axiom.web.handler.DefaultRouteHandler;
import org.zalando.axiom.web.util.HandlerUtils;

public final class GetWithZeroOrOneParameterHandler
extends DefaultRouteHandler {
    private final ObjectMapper mapper;
    private final Object function;

    public GetWithZeroOrOneParameterHandler(ObjectMapper mapper, Object function) {
        this.mapper = mapper;
        this.function = function;
    }

    public void handle(RoutingContext routingContext) {
        this.executeAsyncFunction(routingContext, asyncResult -> {
            if (asyncResult.failed()) {
                routingContext.fail(500);
            } else if (asyncResult == null || asyncResult.result() == null) {
                routingContext.response().setStatusCode(404).end();
            } else {
                try {
                    routingContext.response().setStatusCode(200).end(this.mapper.writeValueAsString(asyncResult.result()));
                }
                catch (JsonProcessingException e) {
                    this.handleError(String.format("Could not serialize result [%s]!", routingContext.currentRoute().getPath()), e, routingContext);
                }
            }
        });
    }

    private <T> void executeAsyncFunction(RoutingContext routingContext, AsyncResultHandler<T> handler) {
        if (this.function instanceof AsyncStringFunction) {
            ((AsyncStringFunction)this.function).apply(HandlerUtils.getOnlyValue(routingContext), handler);
        } else if (this.function instanceof AsyncSupplier) {
            ((AsyncSupplier)this.function).get(handler);
        } else if (this.function instanceof AsyncIntFunction) {
            ((AsyncIntFunction)this.function).apply(Integer.parseInt(HandlerUtils.getOnlyValue(routingContext)), handler);
        } else {
            throw new UnsupportedOperationException(String.format("Async controller with this arity is not yet implemented: [%s]", this.function.getClass().getName()));
        }
    }
}

