/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.handler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.TimeUnit;
import org.zalando.axiom.web.util.Strings;

public class MetricsHandler
implements Handler<RoutingContext> {
    private final MetricRegistry metricRegistry;
    private final Handler<RoutingContext> subHandler;
    private final String path;

    public MetricsHandler(MetricRegistry metricRegistry, Handler<RoutingContext> subHandler, String path) {
        this.metricRegistry = metricRegistry;
        this.subHandler = subHandler;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext routingContext) {
        HttpServerRequest request = routingContext.request();
        String timerMetricsName = Strings.toMetricsName(request.method(), this.path);
        String counterMetricsName = "statusCodes." + Strings.toMetricsName(request.method(), this.path);
        long start = System.currentTimeMillis();
        try {
            this.subHandler.handle((Object)routingContext);
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            int statusCode = routingContext.response().getStatusCode();
            Timer allTimer = this.metricRegistry.timer(timerMetricsName);
            allTimer.update(duration, TimeUnit.MILLISECONDS);
            Timer statusTimer = this.metricRegistry.timer(Integer.toString(statusCode) + '.' + timerMetricsName);
            statusTimer.update(duration, TimeUnit.MILLISECONDS);
            Counter counter = this.metricRegistry.counter(counterMetricsName + '.' + statusCode);
            counter.inc();
        }
    }
}

