/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.axiom.web.binding.functions.AsyncFunction;
import org.zalando.axiom.web.handler.DefaultRouteHandler;
import org.zalando.axiom.web.util.Preconditions;

public class PostHandler<T>
extends DefaultRouteHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostHandler.class);
    private final Operation operation;
    private final ObjectMapper mapper;
    private final Object function;
    private final Class<T> paramType;

    public PostHandler(Operation operation, ObjectMapper mapper, Object function, Class<T> paramType) {
        this.operation = operation;
        this.mapper = mapper;
        this.function = function;
        this.paramType = paramType;
    }

    public void handle(RoutingContext routingContext) {
        String bodyAsJson = routingContext.getBodyAsString("UTF-8");
        Preconditions.checkNotNull(bodyAsJson, "Body must not be null!");
        this.executeFunction(routingContext, bodyAsJson, id -> {
            if (id == null) {
                this.handleNoResult(routingContext);
            } else {
                this.handleResult(routingContext, id);
            }
        });
    }

    private void executeFunction(RoutingContext routingContext, String bodyAsJson, Consumer<Object> callback) {
        try {
            if (!(this.function instanceof AsyncFunction)) {
                throw new UnsupportedOperationException(String.format("Controller with this arity is not yet implemented: [%s]", this.function.getClass().getName()));
            }
            ((AsyncFunction)this.function).apply(this.mapper.readValue(bodyAsJson, this.paramType), this.defaultAsyncResultHandler(routingContext, callback));
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception occurred!", (Throwable)e);
            routingContext.fail(500);
        }
    }

    private void handleNoResult(RoutingContext routingContext) {
        LOGGER.error("No result returned.");
        routingContext.fail(500);
    }

    private void handleResult(RoutingContext routingContext, Object result) {
        HttpServerResponse response = routingContext.response();
        if (this.doSetLocation()) {
            String id = result instanceof String ? result.toString() : this.getIdFromResult(result);
            String path = routingContext.request().path();
            response.headers().set(HttpHeaders.LOCATION, (CharSequence)(path + "/" + id));
        }
        response.setStatusCode(201);
        response.end();
    }

    private String getIdFromResult(Object result) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object idObject = null;
        try {
            MethodHandle getIdMethodHandle = lookup.findVirtual(result.getClass(), "getId", MethodType.methodType(String.class));
            idObject = getIdMethodHandle.invoke(result);
        }
        catch (Throwable throwable) {
            LOGGER.error("Could not call method to retrieve id!", throwable);
        }
        if (idObject == null) {
            throw new IllegalStateException(String.format("Id method on [%s] returned null!", result.getClass()));
        }
        String id = idObject.toString();
        return id;
    }

    private boolean doSetLocation() {
        Map headers = ((Response)this.operation.getResponses().get("201")).getHeaders();
        return headers != null && headers.containsKey("Location");
    }
}

