/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.axiom.web.util;

public final class Types {
    private Types() {
    }

    public static Object castValueToType(String value, Class<?> parameterType) {
        if (parameterType == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (parameterType == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (parameterType == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (parameterType == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (parameterType == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (parameterType == String.class) {
            return value;
        }
        throw new UnsupportedOperationException(String.format("Unhandled type [%s].", parameterType.getName()));
    }

    public static Class<?> getParameterType(String type, String format) {
        switch (type) {
            case "number": {
                switch (format) {
                    case "integer": {
                        return Integer.TYPE;
                    }
                    case "long": {
                        return Long.TYPE;
                    }
                    case "float": {
                        return Float.TYPE;
                    }
                    case "double": {
                        return Double.TYPE;
                    }
                }
                return Integer.TYPE;
            }
            case "integer": {
                switch (format) {
                    case "integer": {
                        return Integer.TYPE;
                    }
                    case "long": {
                        return Long.TYPE;
                    }
                }
                return Integer.TYPE;
            }
            case "string": {
                return String.class;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
        }
        throw new UnsupportedOperationException(String.format("Type [%s] format [%s] not handled.", type, format));
    }
}

