/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.boot.etcd.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.zalando.boot.etcd.EtcdClient;
import org.zalando.boot.etcd.autoconfigure.EtcdClientProperties;

@Configuration
@ConditionalOnMissingBean(value={EtcdClient.class})
@ConditionalOnClass(value={ObjectMapper.class})
@ConditionalOnProperty(prefix="zalando.etcd", name={"enabled"}, matchIfMissing=true)
public class EtcdClientAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={EtcdClientProperties.class})
    @ConditionalOnProperty(prefix="zalando.etcd", name={"serviceName"})
    protected static class DnsDiscoveryConfiguration {
        @Autowired
        private EtcdClientProperties properties;

        protected DnsDiscoveryConfiguration() {
        }

        private List<String> discoverNodes(String serviceName) throws NamingException {
            ArrayList<String> locations = new ArrayList<String>();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            InitialDirContext context = new InitialDirContext(env);
            Attributes attributes = context.getAttributes(serviceName, new String[]{"SRV"});
            NamingEnumeration<? extends Attribute> records = attributes.getAll();
            while (records.hasMore()) {
                Attribute record = records.next();
                NamingEnumeration<?> values = record.getAll();
                while (values.hasMore()) {
                    String dns = (String)values.next();
                    String[] split = dns.split(" ");
                    String host = split[3];
                    if (host.endsWith(".")) {
                        host = host.substring(0, host.length() - 1);
                    }
                    String location = "http://" + host + ":2379";
                    locations.add(location);
                }
            }
            return locations;
        }

        @Bean
        public EtcdClient etcdService() throws NamingException {
            List<String> locations = this.discoverNodes("_etcd-server._tcp." + this.properties.getServiceName());
            EtcdClient client = new EtcdClient(locations.get(0));
            client.setRetryCount(this.properties.getRetryCount());
            client.setRetryDuration(this.properties.getRetryDuration());
            client.setLocationUpdaterEnabled(this.properties.isUpdateLocations());
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setConnectTimeout(this.properties.getConnectTimeout());
            requestFactory.setReadTimeout(this.properties.getReadTimeout());
            client.setRequestFactory((ClientHttpRequestFactory)requestFactory);
            return client;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={EtcdClientProperties.class})
    @ConditionalOnProperty(prefix="zalando.etcd", name={"location"})
    protected static class StaticDiscoveryConfiguration {
        @Autowired
        private EtcdClientProperties properties;

        protected StaticDiscoveryConfiguration() {
        }

        @Bean
        public EtcdClient etcdService() {
            EtcdClient client = new EtcdClient(this.properties.getLocation());
            client.setRetryCount(this.properties.getRetryCount());
            client.setRetryDuration(this.properties.getRetryDuration());
            client.setLocationUpdaterEnabled(this.properties.isUpdateLocations());
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setConnectTimeout(this.properties.getConnectTimeout());
            requestFactory.setReadTimeout(this.properties.getReadTimeout());
            client.setRequestFactory((ClientHttpRequestFactory)requestFactory);
            return client;
        }
    }
}

