/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.boot.etcd.autoconfigure;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="zalando.etcd")
public class EtcdClientProperties {
    private String serviceName;
    private String[] location;
    private boolean enabled = true;
    private int connectTimeout = 1000;
    private int readTimeout = 3000;
    private int retryCount = 0;
    private int retryDuration = 0;
    private boolean updateLocations = true;

    public String getServiceName() {
        return this.serviceName;
    }

    public String[] getLocation() {
        return this.location;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getRetryDuration() {
        return this.retryDuration;
    }

    public boolean isUpdateLocations() {
        return this.updateLocations;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setLocation(String[] location) {
        this.location = location;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setRetryDuration(int retryDuration) {
        this.retryDuration = retryDuration;
    }

    public void setUpdateLocations(boolean updateLocations) {
        this.updateLocations = updateLocations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EtcdClientProperties)) {
            return false;
        }
        EtcdClientProperties other = (EtcdClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLocation(), other.getLocation())) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getRetryCount() != other.getRetryCount()) {
            return false;
        }
        if (this.getRetryDuration() != other.getRetryDuration()) {
            return false;
        }
        return this.isUpdateLocations() == other.isUpdateLocations();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EtcdClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLocation());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getRetryCount();
        result = result * 59 + this.getRetryDuration();
        result = result * 59 + (this.isUpdateLocations() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "EtcdClientProperties(serviceName=" + this.getServiceName() + ", location=" + Arrays.deepToString(this.getLocation()) + ", enabled=" + this.isEnabled() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", retryCount=" + this.getRetryCount() + ", retryDuration=" + this.getRetryDuration() + ", updateLocations=" + this.isUpdateLocations() + ")";
    }
}

