/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.dsprovider;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.dsprovider.DataSourceProvider;

public class BitmapShardDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BitmapShardDataSourceProvider.class);
    private final DataSource[] dataSources;
    private final int mask;
    private final List<Integer> distinctShardIds;

    public BitmapShardDataSourceProvider(Map<String, DataSource> connectionDataSources) {
        int maskLength = 0;
        for (Map.Entry<String, DataSource> entry : connectionDataSources.entrySet()) {
            if (entry.getKey().length() <= maskLength) continue;
            maskLength = entry.getKey().length();
        }
        this.mask = (1 << maskLength) - 1;
        this.dataSources = new DataSource[1 << maskLength];
        for (Map.Entry<String, DataSource> entry : connectionDataSources.entrySet()) {
            DataSource ds = entry.getValue();
            for (int i = 0; i < this.dataSources.length; ++i) {
                String binaryString = Strings.repeat((String)"0", (int)maskLength) + Integer.toBinaryString(i);
                if (!binaryString.endsWith(entry.getKey())) continue;
                LOG.debug("Configured {} at index {}", (Object)entry.getValue(), (Object)i);
                if (this.dataSources[i] != null) {
                    throw new IllegalArgumentException("Bitmask misconfigured for shards: two connections configured for index " + i);
                }
                this.dataSources[i] = ds;
            }
        }
        for (int i = 0; i < this.dataSources.length; ++i) {
            if (this.dataSources[i] != null) continue;
            throw new IllegalArgumentException("Not enough connection URLs configured for mask length " + maskLength + ": datasource at index " + i + " is missing");
        }
        this.distinctShardIds = Lists.newArrayList();
        HashSet seenDataSources = Sets.newHashSet();
        for (int i = 0; i < this.dataSources.length; ++i) {
            if (seenDataSources.contains(this.dataSources[i])) continue;
            this.distinctShardIds.add(i);
            seenDataSources.add(this.dataSources[i]);
        }
    }

    public BitmapShardDataSourceProvider(Class<? extends DataSource> dataSourceClass, Map<String, String> commonDataSourceProperties, Map<String, String> connectionUrls) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        int maskLength = 0;
        for (Map.Entry<String, String> entry : connectionUrls.entrySet()) {
            if (entry.getKey().length() <= maskLength) continue;
            maskLength = entry.getKey().length();
        }
        this.mask = (1 << maskLength) - 1;
        this.dataSources = new DataSource[1 << maskLength];
        for (Map.Entry<String, String> entry : connectionUrls.entrySet()) {
            DataSource ds = dataSourceClass.newInstance();
            for (Map.Entry<String, String> prop : commonDataSourceProperties.entrySet()) {
                BeanUtils.setProperty((Object)ds, (String)prop.getKey(), (Object)prop.getValue());
            }
            String[] parts = entry.getValue().split("\\|");
            BeanUtils.setProperty((Object)ds, (String)"jdbcUrl", (Object)parts[0]);
            if (parts.length > 1) {
                BeanUtils.setProperty((Object)ds, (String)"initSQL", (Object)parts[1]);
            }
            for (int i = 0; i < this.dataSources.length; ++i) {
                String binaryString = Strings.repeat((String)"0", (int)maskLength) + Integer.toBinaryString(i);
                if (!binaryString.endsWith(entry.getKey())) continue;
                LOG.debug("Configured " + entry.getValue() + " at index " + i);
                if (this.dataSources[i] != null) {
                    throw new IllegalArgumentException("Bitmask misconfigured for shards: two connections configured for index " + i);
                }
                this.dataSources[i] = ds;
            }
        }
        for (int i = 0; i < this.dataSources.length; ++i) {
            if (this.dataSources[i] != null) continue;
            throw new IllegalArgumentException("Not enough connection URLs configured for mask length " + maskLength + ": datasource at index " + i + " is missing");
        }
        this.distinctShardIds = Lists.newArrayList();
        HashSet seenDataSources = Sets.newHashSet();
        for (int i = 0; i < this.dataSources.length; ++i) {
            if (seenDataSources.contains(this.dataSources[i])) continue;
            this.distinctShardIds.add(i);
            seenDataSources.add(this.dataSources[i]);
        }
    }

    @Override
    public int getDataSourceId(int virtualShardId) {
        return virtualShardId & this.mask;
    }

    @Override
    public DataSource getDataSource(int virtualShardId) {
        return this.dataSources[virtualShardId & this.mask];
    }

    @Override
    public List<Integer> getDistinctShardIds() {
        return this.distinctShardIds;
    }
}

