/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.globalvaluetransformer;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.sprocwrapper.globalvaluetransformer.ValueTransformerUtils;
import org.zalando.sprocwrapper.globalvaluetransformer.annotation.GlobalValueTransformer;
import org.zalando.typemapper.core.ValueTransformer;
import org.zalando.typemapper.core.fieldMapper.GlobalValueTransformerRegistry;

public class GlobalValueTransformerLoader {
    private static final String GLOBAL_VALUE_TRANSFORMER_SEARCH_NAMESPACE = "global.value.transformer.search.namespace";
    private static String namespaceToScan = "org.zalando";
    private static final Logger LOG = LoggerFactory.getLogger(GlobalValueTransformerLoader.class);
    private static boolean scannedClasspath = false;

    public static synchronized ValueTransformer<?, ?> getValueTransformerForClass(Class<?> genericType) throws InstantiationException, IllegalAccessException {
        if (!scannedClasspath) {
            Predicate<String> filter = new Predicate<String>(){

                public boolean apply(String input) {
                    return GlobalValueTransformer.class.getCanonicalName().equals(input);
                }
            };
            String myNameSpaceToScan = null;
            try {
                myNameSpaceToScan = System.getenv(GLOBAL_VALUE_TRANSFORMER_SEARCH_NAMESPACE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Strings.isNullOrEmpty((String)myNameSpaceToScan)) {
                myNameSpaceToScan = namespaceToScan;
            }
            if (!Strings.isNullOrEmpty((String)myNameSpaceToScan)) {
                Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)myNameSpaceToScan))).setUrls(ClasspathHelper.forPackage((String)myNameSpaceToScan, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new TypeAnnotationsScanner().filterResultsBy((Predicate)filter), new SubTypesScanner()}));
                Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(GlobalValueTransformer.class);
                for (Class foundGlobalValueTransformer : typesAnnotatedWith) {
                    Class<?> valueTransformerReturnType;
                    try {
                        valueTransformerReturnType = ValueTransformerUtils.getUnmarshalFromDbClass(foundGlobalValueTransformer);
                        GlobalValueTransformerRegistry.register(valueTransformerReturnType, (ValueTransformer)foundGlobalValueTransformer.newInstance());
                    }
                    catch (RuntimeException e) {
                        LOG.error("Failed to add global transformer [{}] to global registry.", (Object)foundGlobalValueTransformer, (Object)e);
                        continue;
                    }
                    LOG.debug("Global Value Transformer [{}] for type [{}] registered. ", (Object)foundGlobalValueTransformer.getSimpleName(), (Object)valueTransformerReturnType.getSimpleName());
                }
            }
            scannedClasspath = true;
        }
        return GlobalValueTransformerRegistry.getValueTransformerForClass(genericType);
    }

    public static void changeNamespaceToScan(String newNamespace) {
        namespaceToScan = newNamespace;
        scannedClasspath = false;
    }
}

