/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core;

import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.zalando.sprocwrapper.util.NameUtils;
import org.zalando.typemapper.annotations.Embed;
import org.zalando.typemapper.core.DatabaseFieldDescriptor;
import org.zalando.typemapper.core.ValueTransformer;
import org.zalando.typemapper.core.fieldMapper.AnyTransformer;
import org.zalando.typemapper.core.fieldMapper.FieldMapper;
import org.zalando.typemapper.core.fieldMapper.FieldMapperRegister;
import org.zalando.typemapper.core.fieldMapper.ValueTransformerFieldMapper;
import org.zalando.typemapper.exception.NotsupportedTypeException;
import org.zalando.typemapper.postgres.PgTypeHelper;

public class Mapping {
    private final String name;
    private final Class<? extends ValueTransformer<?, ?>> valueTransformer;
    private final Field field;
    private final boolean embed;
    private final Field embedField;
    private FieldMapper fieldMapper;
    private Map<Field, Method> setter = new ConcurrentHashMap<Field, Method>();
    private static final Map<Class, List<Mapping>> cache = new ConcurrentHashMap<Class, List<Mapping>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Mapping> getMappingsForClass(Class clazz) {
        List<Mapping> result = cache.get(clazz);
        if (result != null) return result;
        Class<Mapping> clazz2 = Mapping.class;
        synchronized (Mapping.class) {
            result = cache.get(clazz);
            if (result != null) return result;
            result = Mapping.getMappingsForClass(clazz, false, null);
            for (Class parentClass = clazz.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
                result.addAll(Mapping.getMappingsForClass(parentClass));
            }
            cache.put(clazz, result);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    static List<Mapping> getMappingsForClass(Class clazz, boolean embed, Field embedField) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            fields.add(field);
        }
        for (Class parentClass = clazz.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            for (Field field : parentClass.getDeclaredFields()) {
                fields.add(field);
            }
        }
        for (Field field : fields) {
            Embed embedAnnotation;
            DatabaseFieldDescriptor annotation = PgTypeHelper.getDatabaseFieldDescriptor(field);
            if (annotation != null) {
                String databaseFieldName = Mapping.getDatabaseFieldName(field, annotation.getName());
                result.add(new Mapping(field, databaseFieldName, embed, embedField, annotation.getTransformer()));
            }
            if (embed || (embedAnnotation = field.getAnnotation(Embed.class)) == null) continue;
            result.addAll(Mapping.getMappingsForClass(field.getType(), true, field));
        }
        return result;
    }

    Mapping(Field field, String name, boolean embed, Field embedField, Class<? extends ValueTransformer<?, ?>> valueTransformer) {
        this.name = name;
        this.field = field;
        this.embed = embed;
        this.embedField = embedField;
        this.valueTransformer = valueTransformer;
    }

    public Class getFieldClass() {
        if (this.isOptionalField()) {
            return (Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
        }
        return this.field.getType();
    }

    public boolean isOptionalField() {
        return Optional.class.isAssignableFrom(this.field.getType());
    }

    public Class<? extends ValueTransformer<?, ?>> getValueTransformer() {
        return this.valueTransformer;
    }

    public Method getSetter(Field field) {
        Method method = this.setter.get(field);
        if (method == null) {
            String setterName = "set" + Mapping.capitalize(field.getName());
            try {
                method = field.getDeclaringClass().getDeclaredMethod(setterName, field.getType());
                this.setter.put(field, method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    public Method getSetter() {
        return this.getSetter(this.field);
    }

    public Method getGetter(Field field) {
        String getterName = "get" + Mapping.capitalize(field.getName());
        try {
            return field.getDeclaringClass().getDeclaredMethod(getterName, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static final String getDatabaseFieldName(Field field, String annotationName) {
        if (annotationName != null && !annotationName.isEmpty()) {
            return annotationName;
        }
        return NameUtils.camelCaseToUnderscore(field.getName());
    }

    public Field getField() {
        return this.field;
    }

    public FieldMapper getFieldMapper() throws NotsupportedTypeException, InstantiationException, IllegalAccessException {
        if (this.fieldMapper == null) {
            DatabaseFieldDescriptor databaseFieldDescriptor = PgTypeHelper.getDatabaseFieldDescriptor(this.field);
            if (databaseFieldDescriptor != null && databaseFieldDescriptor.getTransformer() != null && !AnyTransformer.class.equals(this.getValueTransformer())) {
                this.fieldMapper = new ValueTransformerFieldMapper(this.getValueTransformer());
                return this.fieldMapper;
            }
            this.fieldMapper = FieldMapperRegister.getMapperForClass(this.getFieldClass());
        }
        return this.fieldMapper;
    }

    public void map(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.isOptionalField()) {
            value = Optional.fromNullable((Object)value);
        }
        if (this.embed) {
            Method setter;
            Object embedValue = this.getEmbedFieldValue(target);
            if (embedValue == null) {
                embedValue = this.initEmbed(target);
            }
            if ((setter = this.getSetter()) != null) {
                setter.invoke(embedValue, value);
            } else {
                this.getField().setAccessible(true);
                this.getField().set(embedValue, value);
            }
        } else {
            Method setter = this.getSetter();
            if (setter != null) {
                setter.invoke(target, value);
            } else {
                this.getField().setAccessible(true);
                this.getField().set(target, value);
            }
        }
    }

    private Object initEmbed(Object target) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method setter = this.getSetter(this.embedField);
        Object value = this.embedField.getType().newInstance();
        if (setter != null) {
            setter.invoke(target, value);
        } else {
            this.getField().set(target, value);
        }
        return value;
    }

    private Object getEmbedFieldValue(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method setter = this.getGetter(this.embedField);
        Object result = null;
        result = setter != null ? setter.invoke(target, new Object[0]) : this.embedField.get(target);
        return result;
    }

    public String toString() {
        return "Mapping [name=" + this.name + ", field=" + this.field + ", embed=" + this.embed + ", embedField=" + this.embedField + "]";
    }
}

