/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.fieldMapper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.zalando.typemapper.core.ValueTransformer;
import org.zalando.typemapper.core.fieldMapper.BigDecimalFieldMappper;
import org.zalando.typemapper.core.fieldMapper.BooleanFieldMapper;
import org.zalando.typemapper.core.fieldMapper.CharFieldMapper;
import org.zalando.typemapper.core.fieldMapper.DateFieldMapper;
import org.zalando.typemapper.core.fieldMapper.DoubleFieldMapper;
import org.zalando.typemapper.core.fieldMapper.EnumrationFieldMapper;
import org.zalando.typemapper.core.fieldMapper.FieldMapper;
import org.zalando.typemapper.core.fieldMapper.FloatFieldMapper;
import org.zalando.typemapper.core.fieldMapper.GlobalValueTransformerRegistry;
import org.zalando.typemapper.core.fieldMapper.HStoreFieldMapper;
import org.zalando.typemapper.core.fieldMapper.IntFieldMapper;
import org.zalando.typemapper.core.fieldMapper.IntegerFieldMapper;
import org.zalando.typemapper.core.fieldMapper.LongFieldMapper;
import org.zalando.typemapper.core.fieldMapper.NullFieldMapper;
import org.zalando.typemapper.core.fieldMapper.PrimitiveLongFieldMapper;
import org.zalando.typemapper.core.fieldMapper.ShortFieldMapper;
import org.zalando.typemapper.core.fieldMapper.StringFieldMapper;
import org.zalando.typemapper.core.fieldMapper.UUIDFieldMapper;
import org.zalando.typemapper.core.fieldMapper.ValueTransformerFieldMapper;

public class FieldMapperRegister {
    private static final Map<Class, FieldMapper> register = new ConcurrentHashMap<Class, FieldMapper>();
    private static final NullFieldMapper NULL_FIELD_MAPPER = new NullFieldMapper();

    private static void register(Class clazz, FieldMapper mapper) {
        register.put(clazz, mapper);
    }

    public static FieldMapper getMapperForClass(Class clazz) {
        ValueTransformer<?, ?> valueTransformer;
        FieldMapper fieldMapper = register.get(clazz);
        if (fieldMapper == null && (valueTransformer = GlobalValueTransformerRegistry.getValueTransformerForClass(clazz)) != null) {
            fieldMapper = new ValueTransformerFieldMapper(valueTransformer);
            register.put(clazz, fieldMapper);
        }
        if (fieldMapper == null && clazz.getEnumConstants() != null) {
            fieldMapper = register.get(Enum.class);
        }
        if (fieldMapper == null) {
            fieldMapper = NULL_FIELD_MAPPER;
        }
        return fieldMapper;
    }

    static {
        DateFieldMapper dateFieldMapper = new DateFieldMapper();
        FieldMapperRegister.register(Date.class, dateFieldMapper);
        IntegerFieldMapper integerMapper = new IntegerFieldMapper();
        FieldMapperRegister.register(Integer.class, integerMapper);
        IntFieldMapper intMapper = new IntFieldMapper();
        FieldMapperRegister.register(Integer.TYPE, intMapper);
        LongFieldMapper longMapper = new LongFieldMapper();
        FieldMapperRegister.register(Long.class, longMapper);
        PrimitiveLongFieldMapper primitiveLongMapper = new PrimitiveLongFieldMapper();
        FieldMapperRegister.register(Long.TYPE, primitiveLongMapper);
        CharFieldMapper charMapper = new CharFieldMapper();
        FieldMapperRegister.register(Character.TYPE, charMapper);
        FieldMapperRegister.register(Character.class, charMapper);
        StringFieldMapper stringMapper = new StringFieldMapper();
        FieldMapperRegister.register(String.class, stringMapper);
        DoubleFieldMapper doubleMapper = new DoubleFieldMapper();
        FieldMapperRegister.register(Double.class, doubleMapper);
        FieldMapperRegister.register(Double.TYPE, doubleMapper);
        FloatFieldMapper floatMapper = new FloatFieldMapper();
        FieldMapperRegister.register(Float.class, floatMapper);
        FieldMapperRegister.register(Float.TYPE, floatMapper);
        ShortFieldMapper shortMapper = new ShortFieldMapper();
        FieldMapperRegister.register(Short.class, shortMapper);
        FieldMapperRegister.register(Short.TYPE, shortMapper);
        BooleanFieldMapper booleanMapper = new BooleanFieldMapper();
        FieldMapperRegister.register(Boolean.class, booleanMapper);
        FieldMapperRegister.register(Boolean.TYPE, booleanMapper);
        EnumrationFieldMapper enumMapper = new EnumrationFieldMapper();
        FieldMapperRegister.register(Enum.class, enumMapper);
        BigDecimalFieldMappper bigDecimalMapper = new BigDecimalFieldMappper();
        FieldMapperRegister.register(BigDecimal.class, bigDecimalMapper);
        HStoreFieldMapper hstoreMapper = new HStoreFieldMapper();
        FieldMapperRegister.register(Map.class, hstoreMapper);
        UUIDFieldMapper uuidMapper = new UUIDFieldMapper();
        FieldMapperRegister.register(UUID.class, uuidMapper);
    }
}

