/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.core.fieldMapper;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.typemapper.core.DatabaseFieldDescriptor;
import org.zalando.typemapper.core.Mapping;
import org.zalando.typemapper.core.fieldMapper.ArrayFieldMapper;
import org.zalando.typemapper.core.fieldMapper.DefaultObjectMapper;
import org.zalando.typemapper.core.fieldMapper.ObjectMapper;
import org.zalando.typemapper.core.result.ArrayResultNode;
import org.zalando.typemapper.core.result.DbResultNode;
import org.zalando.typemapper.core.result.DbResultNodeType;
import org.zalando.typemapper.core.result.ObjectResultNode;
import org.zalando.typemapper.exception.NotsupportedTypeException;
import org.zalando.typemapper.postgres.PgTypeHelper;

public class ObjectFieldMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectFieldMapper.class);

    private static boolean isRowWithAllFieldsNull(ObjectResultNode node) {
        if (node != null && node.getChildren() != null) {
            for (DbResultNode dbResultNode : node.getChildren()) {
                if (dbResultNode == null || dbResultNode.getValue() == null) continue;
                return false;
            }
        }
        return true;
    }

    public static final Object mapFromDbObjectNode(Class classz, ObjectResultNode node, Mapping mapping) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NotsupportedTypeException {
        Object value;
        DatabaseFieldDescriptor descriptor = PgTypeHelper.getDatabaseFieldDescriptor(mapping.getField());
        if (mapping.isOptionalField() && ObjectFieldMapper.isRowWithAllFieldsNull(node)) {
            value = null;
        } else if (descriptor.getMapper() != DefaultObjectMapper.class) {
            ObjectMapper<?> mapper = descriptor.getMapper().newInstance();
            value = mapper.unmarshalFromDbNode(node);
        } else {
            value = ObjectFieldMapper.mapField(mapping.getFieldClass(), node);
        }
        return value;
    }

    public static final Object mapField(Class clazz, ObjectResultNode node) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NotsupportedTypeException {
        if (node.getChildren() == null) {
            return null;
        }
        Object result = null;
        if (clazz.isEnum()) {
            DbResultNode currentNode = node.getChildByName(node.getType());
            result = Enum.valueOf(clazz, currentNode.getValue());
        } else {
            result = clazz.newInstance();
            List<Mapping> mappings = Mapping.getMappingsForClass(clazz);
            for (Mapping mapping : mappings) {
                DbResultNode currentNode = node.getChildByName(mapping.getName());
                if (currentNode == null) {
                    if (mapping.isOptionalField()) {
                        mapping.map(result, null);
                        continue;
                    }
                    LOG.warn("Could not find value of mapping: {}", (Object)mapping.getName());
                    continue;
                }
                try {
                    if (DbResultNodeType.SIMPLE.equals((Object)currentNode.getNodeType())) {
                        mapping.map(result, mapping.getFieldMapper().mapField(currentNode.getValue(), mapping.getFieldClass()));
                        continue;
                    }
                    if (DbResultNodeType.OBJECT.equals((Object)currentNode.getNodeType())) {
                        mapping.map(result, ObjectFieldMapper.mapFromDbObjectNode(clazz, (ObjectResultNode)currentNode, mapping));
                        continue;
                    }
                    if (!DbResultNodeType.ARRAY.equals((Object)currentNode.getNodeType())) continue;
                    mapping.map(result, ArrayFieldMapper.mapField(mapping.getField(), (ArrayResultNode)currentNode));
                }
                catch (Exception e) {
                    LOG.error("Failed to map property {} of class {}", new Object[]{mapping.getName(), clazz.getSimpleName(), e});
                }
            }
        }
        return result;
    }
}

