/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.typemapper.postgres;

import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import org.zalando.typemapper.postgres.AbstractPgSerializer;
import org.zalando.typemapper.postgres.PgTypeHelper;

abstract class AbstractPgCollectionSerializer<E>
extends AbstractPgSerializer {
    protected final Collection<E> collection;

    protected AbstractPgCollectionSerializer(Collection<E> c) {
        this.collection = c;
    }

    @Override
    public final boolean isNull() {
        return this.collection == null;
    }

    protected abstract char getOpeningChar();

    protected abstract char getClosingChar();

    @Override
    protected final String getEmpty() {
        return new StringBuilder(2).append(this.getOpeningChar()).append(this.getClosingChar()).toString();
    }

    @Override
    protected boolean isEmpty() {
        return this.collection.isEmpty();
    }

    protected abstract void quoteChar(StringBuilder var1, char var2);

    @Override
    protected abstract void appendNull(StringBuilder var1);

    @Override
    public final StringBuilder quote(StringBuilder sb, CharSequence s) {
        char ch;
        int i;
        if (sb == null) {
            throw new NullPointerException("Passed StringBuilder should be not null");
        }
        if (s == null) {
            throw new NullPointerException("Null values should be processed by the caller");
        }
        int l = s.length();
        if (l == 0) {
            return sb.append("\"\"");
        }
        char openingChar = this.getOpeningChar();
        char closingChar = this.getClosingChar();
        boolean needsQuotation = false;
        int neededLength = 0;
        for (i = 0; i < l; ++i) {
            ch = s.charAt(i);
            ++neededLength;
            if (ch == '\"' || ch == '\\') {
                needsQuotation = true;
                ++neededLength;
            }
            if (!Character.isWhitespace(ch) && ch != ',' && ch != openingChar && ch != closingChar) continue;
            needsQuotation = true;
        }
        if (needsQuotation) {
            neededLength += 2;
        }
        sb.ensureCapacity(sb.length() + neededLength);
        if (needsQuotation) {
            sb.append('\"');
        }
        for (i = 0; i < l; ++i) {
            ch = s.charAt(i);
            if (ch == '\"' || ch == '\\') {
                this.quoteChar(sb, ch);
                continue;
            }
            sb.append(ch);
        }
        if (needsQuotation) {
            sb.append('\"');
        }
        return sb;
    }

    @Override
    public final String toPgString(Connection connection) {
        Iterator<E> iterator = this.collection.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOpeningChar());
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            E element = iterator.next();
            if (element == null) {
                this.appendNull(sb);
            } else {
                this.quote(sb, PgTypeHelper.toPgString(element, connection));
            }
            hasNext = iterator.hasNext();
            if (!hasNext) break;
            sb.append(',');
        }
        sb.append(this.getClosingChar());
        return sb.toString();
    }
}

