/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.sprocwrapper.proxy;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.concurrent.Immutable;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.RowMapper;
import org.zalando.sprocwrapper.SProcCall;
import org.zalando.sprocwrapper.SProcService;
import org.zalando.sprocwrapper.dsprovider.DataSourceProvider;
import org.zalando.sprocwrapper.dsprovider.SameConnectionDatasource;
import org.zalando.sprocwrapper.globalvaluetransformer.GlobalValueTransformerLoader;
import org.zalando.sprocwrapper.proxy.InvocationContext;
import org.zalando.sprocwrapper.proxy.ShardKeyParameter;
import org.zalando.sprocwrapper.proxy.StoredProcedureParameter;
import org.zalando.sprocwrapper.proxy.executors.Executor;
import org.zalando.sprocwrapper.proxy.executors.ExecutorWrapper;
import org.zalando.sprocwrapper.proxy.executors.GlobalTransformerExecutorWrapper;
import org.zalando.sprocwrapper.proxy.executors.MultiRowSimpleTypeExecutor;
import org.zalando.sprocwrapper.proxy.executors.MultiRowTypeMapperExecutor;
import org.zalando.sprocwrapper.proxy.executors.SingleRowCustomMapperExecutor;
import org.zalando.sprocwrapper.proxy.executors.SingleRowSimpleTypeExecutor;
import org.zalando.sprocwrapper.proxy.executors.SingleRowTypeMapperExecutor;
import org.zalando.sprocwrapper.proxy.executors.ValidationExecutorWrapper;
import org.zalando.sprocwrapper.sharding.ShardedDataAccessException;
import org.zalando.sprocwrapper.sharding.ShardedObject;
import org.zalando.sprocwrapper.sharding.VirtualShardKeyStrategy;
import org.zalando.typemapper.core.ValueTransformer;

@Immutable
class StoredProcedure {
    private static final int TRUNCATE_DEBUG_PARAMS_MAX_LENGTH = 1024;
    private static final String TRUNCATE_DEBUG_PARAMS_ELLIPSIS = " ...";
    private static final Logger LOG = LoggerFactory.getLogger(StoredProcedure.class);
    private final String name;
    private final List<StoredProcedureParameter> params;
    private final int[] types;
    private final String sqlParameterList;
    private final String query;
    private final Class<?> returnType;
    private final VirtualShardKeyStrategy shardStrategy;
    private final List<ShardKeyParameter> shardKeyParameters;
    private final boolean autoPartition;
    private final boolean collectionResult;
    private final boolean runOnAllShards;
    private final boolean searchShards;
    private final boolean parallel;
    private final boolean readOnly;
    private final SProcService.WriteTransaction writeTransaction;
    private final Executor executor;
    private static final Executor MULTI_ROW_SIMPLE_TYPE_EXECUTOR = new MultiRowSimpleTypeExecutor();
    private static final Executor MULTI_ROW_TYPE_MAPPER_EXECUTOR = new MultiRowTypeMapperExecutor();
    private static final Executor SINGLE_ROW_SIMPLE_TYPE_EXECUTOR = new SingleRowSimpleTypeExecutor();
    private static final Executor SINGLE_ROW_TYPE_MAPPER_EXECUTOR = new SingleRowTypeMapperExecutor();
    private static final ExecutorService PARALLEL_THREAD_POOL = Executors.newCachedThreadPool();
    private final long timeout;
    private final SProcCall.AdvisoryLock adivsoryLock;

    public StoredProcedure(String name, String query, List<StoredProcedureParameter> params, Type genericType, VirtualShardKeyStrategy sStrategy, List<ShardKeyParameter> shardKeyParameters, boolean runOnAllShards, boolean searchShards, boolean parallel, RowMapper<?> resultMapper, long timeout, SProcCall.AdvisoryLock advisoryLock, boolean useValidation, boolean readOnly, SProcService.WriteTransaction writeTransaction) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Executor exec;
        this.name = name;
        this.params = new ArrayList<StoredProcedureParameter>(params);
        this.types = StoredProcedure.createTypes(params);
        this.sqlParameterList = StoredProcedure.createSqlParameterList(params);
        this.query = query != null ? query : StoredProcedure.defaultQuery(name, this.sqlParameterList);
        this.shardStrategy = sStrategy;
        this.shardKeyParameters = new ArrayList<ShardKeyParameter>(shardKeyParameters);
        this.autoPartition = StoredProcedure.isAutoPartition(shardKeyParameters);
        this.runOnAllShards = runOnAllShards;
        this.searchShards = searchShards;
        this.parallel = parallel;
        this.readOnly = readOnly;
        this.writeTransaction = writeTransaction;
        this.adivsoryLock = advisoryLock;
        this.timeout = timeout;
        ValueTransformer<?, ?> valueTransformerForClass = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            if (List.class.isAssignableFrom((Class)pType.getRawType()) && pType.getActualTypeArguments().length > 0) {
                this.returnType = (Class)pType.getActualTypeArguments()[0];
                valueTransformerForClass = GlobalValueTransformerLoader.getValueTransformerForClass(this.returnType);
                exec = valueTransformerForClass != null || SingleRowSimpleTypeExecutor.SIMPLE_TYPES.containsKey(this.returnType) ? MULTI_ROW_SIMPLE_TYPE_EXECUTOR : MULTI_ROW_TYPE_MAPPER_EXECUTOR;
                this.collectionResult = true;
            } else {
                this.collectionResult = false;
                exec = SINGLE_ROW_TYPE_MAPPER_EXECUTOR;
                this.returnType = (Class)pType.getRawType();
            }
        } else {
            this.collectionResult = false;
            this.returnType = (Class)genericType;
            valueTransformerForClass = GlobalValueTransformerLoader.getValueTransformerForClass(this.returnType);
            exec = valueTransformerForClass != null || SingleRowSimpleTypeExecutor.SIMPLE_TYPES.containsKey(this.returnType) ? SINGLE_ROW_SIMPLE_TYPE_EXECUTOR : (resultMapper != null ? new SingleRowCustomMapperExecutor(resultMapper) : SINGLE_ROW_TYPE_MAPPER_EXECUTOR);
        }
        if (this.timeout > 0L || this.adivsoryLock != null && !this.adivsoryLock.equals(SProcCall.AdvisoryLock.NoLock.LOCK)) {
            exec = new ExecutorWrapper(exec, this.timeout, this.adivsoryLock);
        }
        if (useValidation) {
            exec = new ValidationExecutorWrapper(exec);
        }
        if (valueTransformerForClass != null) {
            exec = new GlobalTransformerExecutorWrapper(exec);
        }
        this.executor = exec;
    }

    public String getName() {
        return this.name;
    }

    private Object[] getParams(Object[] origParams, Connection connection) {
        Object[] ps = new Object[this.params.size()];
        int i = 0;
        for (StoredProcedureParameter p : this.params) {
            try {
                ps[i] = p.mapParam(origParams[p.getJavaPos()], connection);
            }
            catch (Exception e) {
                String errorMessage = "Could not map input parameter for stored procedure " + this.name + " of type " + p.getType() + " at position " + p.getJavaPos() + ": " + (p.isSensitive() ? "<SENSITIVE>" : origParams[p.getJavaPos()]);
                LOG.error(errorMessage, (Throwable)e);
                throw new IllegalArgumentException(errorMessage, e);
            }
            ++i;
        }
        return ps;
    }

    private static int[] createTypes(List<StoredProcedureParameter> params) {
        int[] types = new int[params.size()];
        int i = 0;
        for (StoredProcedureParameter p : params) {
            types[i++] = p.getType();
        }
        return types;
    }

    private int getShardId(Object[] objs) {
        if (this.shardKeyParameters.isEmpty()) {
            return this.shardStrategy.getShardId(null);
        }
        Object[] keys = new Object[this.shardKeyParameters.size()];
        int i = 0;
        for (ShardKeyParameter p : this.shardKeyParameters) {
            Object obj = objs[p.getPos()];
            if (obj instanceof ShardedObject) {
                obj = ((ShardedObject)obj).getShardKey();
            }
            keys[i] = obj;
            ++i;
        }
        return this.shardStrategy.getShardId(keys);
    }

    public String getSqlParameterList() {
        return this.sqlParameterList;
    }

    private static String createSqlParameterList(List<StoredProcedureParameter> params) {
        Object s = "";
        boolean first = true;
        for (int i = 1; i <= params.size(); ++i) {
            if (!first) {
                s = (String)s + ",";
            }
            first = false;
            s = (String)s + "?";
        }
        return s;
    }

    private static String defaultQuery(String name, String sqlParameterList) {
        return "SELECT * FROM " + name + " ( " + sqlParameterList + " )";
    }

    private static boolean isAutoPartition(List<ShardKeyParameter> shardKeyParameters) {
        for (ShardKeyParameter p : shardKeyParameters) {
            if (!List.class.isAssignableFrom(p.getType())) continue;
            return true;
        }
        return false;
    }

    private String getDebugLog(Object[] args) {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append('(');
        int i = 0;
        for (Object param : args) {
            if (i > 0) {
                sb.append(',');
            }
            if (param == null) {
                sb.append("NULL");
            } else if (this.params.get(i).isSensitive()) {
                sb.append("<SENSITIVE>");
            } else {
                sb.append(param);
            }
            ++i;
            if (sb.length() > 1024) break;
        }
        if (sb.length() > 1024) {
            return sb.substring(0, 1024) + " ...)";
        }
        sb.append(')');
        return sb.toString();
    }

    private Map<Integer, Object[]> partitionArguments(DataSourceProvider dataSourceProvider, Object[] args) {
        TreeMap argumentsByShardId = Maps.newTreeMap();
        HashMap shardIdByDataSource = Maps.newHashMap();
        List originalArgument = (List)args[0];
        if (originalArgument == null || originalArgument.isEmpty()) {
            throw new IllegalArgumentException("ShardKey (first argument) of sproc '" + this.name + "' not defined");
        }
        List partitionedArgument = null;
        Object[] partitionedArguments = null;
        for (Object key : originalArgument) {
            int shardId = this.getShardId(new Object[]{key});
            DataSource dataSource = dataSourceProvider.getDataSource(shardId);
            Integer existingShardId = (Integer)shardIdByDataSource.get(dataSource);
            if (existingShardId != null) {
                shardId = existingShardId;
            } else {
                shardIdByDataSource.put(dataSource, shardId);
            }
            partitionedArguments = (Object[])argumentsByShardId.get(shardId);
            if (partitionedArguments == null) {
                partitionedArgument = Lists.newArrayList();
                partitionedArguments = new Object[args.length];
                partitionedArguments[0] = partitionedArgument;
                if (args.length > 1) {
                    System.arraycopy(args, 1, partitionedArguments, 1, args.length - 1);
                }
                argumentsByShardId.put(shardId, partitionedArguments);
            } else {
                partitionedArgument = (List)partitionedArguments[0];
            }
            partitionedArgument.add(key);
        }
        return argumentsByShardId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(DataSourceProvider dp, InvocationContext invocation) {
        ArrayList shardIds = null;
        Map<Object, Object> partitionedArguments = null;
        if (this.runOnAllShards || this.searchShards) {
            shardIds = dp.getDistinctShardIds();
        } else if (this.autoPartition) {
            partitionedArguments = this.partitionArguments(dp, invocation.getArgs());
            shardIds = Lists.newArrayList(partitionedArguments.keySet());
        } else {
            shardIds = Lists.newArrayList((Object[])new Integer[]{this.getShardId(invocation.getArgs())});
        }
        if (partitionedArguments == null) {
            partitionedArguments = Maps.newHashMap();
            for (int shardId : shardIds) {
                partitionedArguments.put(shardId, invocation.getArgs());
            }
        }
        DataSource firstDs = dp.getDataSource(shardIds.get(0));
        Connection connection = null;
        try {
            connection = firstDs.getConnection();
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("Failed to acquire connection for virtual shard " + shardIds.get(0) + " for " + this.name, e);
        }
        ArrayList paramValues = Lists.newArrayList();
        try {
            Iterator iterator = shardIds.iterator();
            while (iterator.hasNext()) {
                int shardId = (Integer)iterator.next();
                paramValues.add(this.getParams((Object[])partitionedArguments.get(shardId), connection));
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable t) {
                    LOG.warn("Could not release connection", t);
                }
            }
        }
        if (shardIds.size() == 1 && !this.autoPartition) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getDebugLog((Object[])paramValues.get(0)));
            }
            return this.execute(firstDs, (Object[])paramValues.get(0), invocation);
        }
        Map<Integer, SameConnectionDatasource> transactionalDatasources = null;
        try {
            transactionalDatasources = this.startTransaction(dp, shardIds);
            ArrayList results = Lists.newArrayList();
            Object sprocResult = null;
            long start = System.currentTimeMillis();
            sprocResult = this.parallel ? this.executeInParallel(dp, invocation, shardIds, paramValues, transactionalDatasources, results, sprocResult) : this.executeSequential(dp, invocation, shardIds, paramValues, transactionalDatasources, results, sprocResult);
            if (LOG.isTraceEnabled()) {
                LOG.trace("[{}] execution of [{}] on [{}] shards took [{}] ms", new Object[]{this.parallel ? "parallel" : "serial", this.name, shardIds.size(), System.currentTimeMillis() - start});
            }
            this.commitTransaction(transactionalDatasources);
            if (this.collectionResult) {
                return results;
            }
            return sprocResult;
        }
        catch (RuntimeException runtimeException) {
            LOG.trace("[{}] execution of [{}] on [{}] shards aborted by runtime exception [{}]", new Object[]{this.parallel ? "parallel" : "serial", this.name, shardIds.size(), runtimeException.getMessage(), runtimeException});
            this.rollbackTransaction(transactionalDatasources);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            LOG.trace("[{}] execution of [{}] on [{}] shards aborted by throwable exception [{}]", new Object[]{this.parallel ? "parallel" : "serial", this.name, shardIds.size(), throwable.getMessage(), throwable});
            this.rollbackTransaction(transactionalDatasources);
            throw new RuntimeException(throwable);
        }
    }

    private Object executeSequential(DataSourceProvider dp, InvocationContext invocation, List<Integer> shardIds, List<Object[]> paramValues, Map<Integer, SameConnectionDatasource> transactionalDatasources, List<?> results, Object sprocResult) {
        int i = 0;
        ArrayList exceptions = Lists.newArrayList();
        ImmutableMap.Builder causes = ImmutableMap.builder();
        for (int shardId : shardIds) {
            DataSource shardDs = this.getShardDs(dp, transactionalDatasources, shardId);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getDebugLog(paramValues.get(i)));
            }
            sprocResult = null;
            try {
                sprocResult = this.execute(shardDs, paramValues.get(i), invocation);
            }
            catch (Exception e) {
                exceptions.add("shardId: " + shardId + ", message: " + e.getMessage() + ", query: " + this.query);
                causes.put((Object)shardId, (Object)e);
            }
            if (this.addResultsBreakWhenSharded(results, sprocResult)) break;
            ++i;
        }
        if (!exceptions.isEmpty()) {
            throw new ShardedDataAccessException("Got exception(s) while executing sproc on shards: " + Joiner.on((String)", ").join((Iterable)exceptions), (Map<Integer, Throwable>)causes.build());
        }
        return sprocResult;
    }

    private Object executeInParallel(DataSourceProvider dp, InvocationContext invocation, List<Integer> shardIds, List<Object[]> paramValues, Map<Integer, SameConnectionDatasource> transactionalDatasources, List<?> results, Object sprocResult) {
        HashMap tasks = Maps.newHashMapWithExpectedSize((int)shardIds.size());
        int i = 0;
        for (int shardId : shardIds) {
            DataSource shardDs = this.getShardDs(dp, transactionalDatasources, shardId);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getDebugLog(paramValues.get(i)));
            }
            FutureTask<Object> task = new FutureTask<Object>(this.with(shardDs, paramValues.get(i), invocation));
            tasks.put(shardId, task);
            PARALLEL_THREAD_POOL.execute(task);
            ++i;
        }
        ArrayList exceptions = Lists.newArrayList();
        ImmutableMap.Builder causes = ImmutableMap.builder();
        for (Map.Entry taskToFinish : tasks.entrySet()) {
            try {
                sprocResult = ((FutureTask)taskToFinish.getValue()).get();
            }
            catch (InterruptedException ex) {
                exceptions.add("got sharding execution exception: " + ex.getMessage() + ", query: " + this.query);
                causes.put((Object)((Integer)taskToFinish.getKey()), (Object)ex);
            }
            catch (ExecutionException ex) {
                exceptions.add("got sharding execution exception: " + ex.getCause().getMessage() + ", query: " + this.query);
                causes.put((Object)((Integer)taskToFinish.getKey()), (Object)ex.getCause());
            }
            if (!this.addResultsBreakWhenSharded(results, sprocResult)) continue;
            break;
        }
        if (!exceptions.isEmpty()) {
            throw new ShardedDataAccessException("Got exception(s) while executing sproc on shards: " + Joiner.on((String)", ").join((Iterable)exceptions), (Map<Integer, Throwable>)causes.build());
        }
        return sprocResult;
    }

    private Callable<Object> with(final DataSource shardDs, final Object[] params, final InvocationContext invocation) {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return StoredProcedure.this.execute(shardDs, params, invocation);
            }
        };
    }

    private Object execute(DataSource shardDs, Object[] params, InvocationContext invocation) {
        return this.executor.executeSProc(shardDs, this.query, params, this.types, invocation, this.returnType);
    }

    private boolean addResultsBreakWhenSharded(Collection results, Object sprocResult) {
        boolean breakSearch = false;
        if (this.collectionResult && sprocResult != null && !((Collection)sprocResult).isEmpty()) {
            results.addAll((Collection)sprocResult);
            breakSearch = this.searchShards;
        } else if (!this.collectionResult && sprocResult != null && this.searchShards) {
            breakSearch = true;
        }
        return breakSearch;
    }

    private DataSource getShardDs(DataSourceProvider dp, Map<Integer, SameConnectionDatasource> transactionIds, int shardId) {
        if (transactionIds.isEmpty()) {
            return dp.getDataSource(shardId);
        }
        return transactionIds.get(shardId);
    }

    private Map<Integer, SameConnectionDatasource> startTransaction(DataSourceProvider dp, List<Integer> shardIds) throws SQLException {
        HashMap ret = Maps.newHashMap();
        if (!this.readOnly && this.writeTransaction != SProcService.WriteTransaction.NONE) {
            for (int shardId : shardIds) {
                DataSource shardDs = dp.getDataSource(shardId);
                SameConnectionDatasource sameConnDs = new SameConnectionDatasource(shardDs.getConnection());
                ret.put(shardId, sameConnDs);
                LOG.trace("startTransaction on shard [{}]", (Object)shardId);
                Statement st = sameConnDs.getConnection().createStatement();
                st.execute("BEGIN");
                st.close();
            }
        }
        return ret;
    }

    private void commitTransaction(Map<Integer, SameConnectionDatasource> datasources) {
        if (!this.readOnly && this.writeTransaction != SProcService.WriteTransaction.NONE) {
            if (this.writeTransaction == SProcService.WriteTransaction.ONE_PHASE) {
                for (Map.Entry<Integer, SameConnectionDatasource> shardEntry : datasources.entrySet()) {
                    try {
                        LOG.trace("commitTransaction on shard [{}]", (Object)shardEntry.getKey());
                        DataSource shardDs = shardEntry.getValue();
                        Statement st = shardDs.getConnection().createStatement();
                        st.execute("COMMIT");
                        st.close();
                        shardEntry.getValue().close();
                    }
                    catch (Exception e) {
                        LOG.error("ERROR: could not commitTransaction on shard [{}] - this will produce inconsistent data.", (Object)shardEntry.getKey(), (Object)e);
                    }
                }
            } else if (this.writeTransaction == SProcService.WriteTransaction.TWO_PHASE) {
                boolean commitFailed = false;
                String transactionId = "sprocwrapper_" + UUID.randomUUID();
                String prepareTransactionStatement = "PREPARE TRANSACTION '" + transactionId + "'";
                for (Map.Entry<Integer, SameConnectionDatasource> shardEntry : datasources.entrySet()) {
                    try {
                        LOG.trace("prepare transaction on shard [{}]", (Object)shardEntry.getKey());
                        DataSource shardDs = shardEntry.getValue();
                        Statement st = shardDs.getConnection().createStatement();
                        st.execute(prepareTransactionStatement);
                        st.close();
                    }
                    catch (Exception e) {
                        commitFailed = true;
                        LOG.debug("prepare transaction [{}] on shard [{}] failed!", new Object[]{transactionId, shardEntry.getKey(), e});
                    }
                }
                if (commitFailed) {
                    this.rollbackPrepared(datasources, transactionId);
                } else {
                    String commitStatement = "COMMIT PREPARED '" + transactionId + "'";
                    for (Map.Entry<Integer, SameConnectionDatasource> shardEntry : datasources.entrySet()) {
                        try {
                            LOG.trace("commit prepared transaction [{}] on shard [{}]", (Object)transactionId, (Object)shardEntry.getKey());
                            DataSource shardDs = shardEntry.getValue();
                            Statement st = shardDs.getConnection().createStatement();
                            st.execute(commitStatement);
                            st.close();
                            shardEntry.getValue().close();
                        }
                        catch (Exception e) {
                            commitFailed = true;
                            LOG.error("FAILED: could not commit prepared transaction [{}] on shard [{}] - this will produce inconsistent data.", new Object[]{transactionId, shardEntry.getKey(), e});
                        }
                    }
                    if (commitFailed) {
                        this.rollbackPrepared(datasources, transactionId);
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown writeTransaction state: " + this.writeTransaction);
            }
        }
    }

    private void rollbackPrepared(Map<Integer, SameConnectionDatasource> datasources, String transactionId) {
        String rollbackQuery = "ROLLBACK PREPARED '" + transactionId + "'";
        for (Map.Entry<Integer, SameConnectionDatasource> shardEntry : datasources.entrySet()) {
            try {
                LOG.error("rollback prepared transaction [{}] on shard [{}]", (Object)transactionId, (Object)shardEntry.getKey());
                DataSource shardDs = shardEntry.getValue();
                Statement st = shardDs.getConnection().createStatement();
                st.execute(rollbackQuery);
                st.close();
                shardEntry.getValue().close();
            }
            catch (Exception e) {
                LOG.error("FAILED: could not rollback prepared transaction [{}] on shard [{}] - this will produce inconsistent data.", new Object[]{transactionId, shardEntry.getKey(), e});
            }
        }
    }

    private void rollbackTransaction(Map<Integer, SameConnectionDatasource> datasources) {
        if (!this.readOnly && this.writeTransaction != SProcService.WriteTransaction.NONE) {
            for (Map.Entry<Integer, SameConnectionDatasource> shardEntry : datasources.entrySet()) {
                try {
                    LOG.trace("rollbackTransaction on shard [{}]", (Object)shardEntry.getKey());
                    DataSource shardDs = shardEntry.getValue();
                    Statement st = shardDs.getConnection().createStatement();
                    st.execute("ROLLBACK");
                    st.close();
                    shardEntry.getValue().close();
                }
                catch (Exception e) {
                    LOG.error("ERROR: could not rollback on shard [{}] - this will produce inconsistent data.", (Object)shardEntry.getKey());
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append('(');
        boolean f = true;
        for (StoredProcedureParameter p : this.params) {
            if (!f) {
                sb.append(',');
            }
            f = false;
            sb.append(p.getType());
            if ("".equals(p.getTypeName())) continue;
            sb.append("=>").append(p.getTypeName());
        }
        sb.append(')');
        return sb.toString();
    }
}

